/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.form;

import de.intarsys.cwt.awt.image.ImageIOImageContainer;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.pdf.app.form.PACKAGE;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.tools.activity.RequestFile;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.StreamLocator;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PDFormTools {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static PDForm createForm(PDImage image) {
        if (image == null) {
            return null;
        }
        PDForm form = (PDForm)PDForm.META.createNew();
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        creator.saveState();
        creator.transform((float)image.getWidth(), 0.0f, 0.0f, (float)image.getHeight(), 0.0f, 0.0f);
        creator.doXObject(null, (PDXObject)image);
        creator.restoreState();
        creator.close();
        form.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
        form.cosGetStream().getEncodedBytes();
        CDSRectangle bbox = new CDSRectangle(0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight());
        form.setBoundingBox(bbox);
        CDSMatrix matrix = new CDSMatrix();
        matrix.translate(-bbox.getWidth() / 2.0f, -bbox.getHeight() / 2.0f);
        form.setMatrix(matrix);
        return form;
    }

    public static PDForm loadImage() throws IOException {
        IMessage title = Msg.getMessage("PDFormTools.TitleLoadImage", new Object[0]);
        String path = RequestFile.requestFileLoad((IMessage)title, (String[])new String[]{Msg.getString("PDFormTools.ImageExtensions", new Object[0])}, (String[])new String[]{Msg.getString("PDFormTools.ImageExtensionsName", new Object[0])}, null);
        if (path == null) {
            return null;
        }
        return PDFormTools.loadImage(new File(path), 0);
    }

    public static PDForm loadImage(File file, int index) throws IOException {
        return PDFormTools.loadImage((ILocator)new FileLocator(file), index);
    }

    public static PDForm loadImage(ILocator locator, int index) throws IOException {
        try (ImageIOImageContainer container = ImageIOImageContainer.createFromLocator((ILocator)locator);){
            IImageEntry image = container.getImageAt(index);
            PDForm pDForm = PDFormTools.createForm(((IPlatformImage)image.asImage(IPlatformImage.class, new ImageConvertOption[0])).getPDImage());
            return pDForm;
        }
    }

    public static PDForm loadUnknownIcon() {
        InputStream is = PDFormTools.class.getResourceAsStream("/icons/unknown.png");
        StreamLocator locator = new StreamLocator(is, "unknown", "png");
        try {
            return PDFormTools.loadImage((ILocator)locator, 0);
        }
        catch (IOException e) {
            return null;
        }
    }
}

