/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.image;

import de.intarsys.pdf.app.image.TIFFT6Compressor;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.CCITTFaxFilter;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class PDImageFactory {
    private static final String JPEG_FORMAT_NAME = "jpeg";
    private static final int MAX_COLOR_MAP_SIZE = 256;
    private static final COSName DK_Range = COSName.constant((String)"Range");

    public PDImage createPDImageFromJpeg(byte[] imageData) throws IOException {
        BufferedImage image = this.readJpegImage(imageData);
        return this.createPDImageFromJpeg(image, imageData);
    }

    /*
     * Exception decompiling
     */
    private BufferedImage readJpegImage(byte[] imageData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PDImage createPDImageFromJpeg(BufferedImage image, byte[] imageData) {
        return this.createPDImageFromJpeg(image.getWidth(), image.getHeight(), image.getColorModel(), imageData);
    }

    public PDImage createPDImageFromJpeg(int width, int height, ColorModel colorModel, byte[] imageData) {
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(width);
        pdImage.setHeight(height);
        pdImage.setBitsPerComponent(colorModel.getComponentSize(0));
        this.setColorSpace(pdImage, this.toPDColorSpace(colorModel));
        COSStream stream = pdImage.cosGetStream();
        stream.addFilter(Filter.CN_Filter_DCTDecode);
        stream.setEncodedBytes(imageData);
        return pdImage;
    }

    public PDImage createPDImage(BufferedImage image) {
        PDImage pdImage = this.isGray(image) ? this.createGrayPDImage(image) : (this.isMonochrome(image) ? this.createMonochromePDImage(image) : (this.isIndexed(image) ? this.createIndexedPDImage(image) : this.createRGBPDImage(image)));
        int transparency = image.getColorModel().getTransparency();
        if (transparency == 2) {
            COSObject colorKeyMask = this.computeColorKeyMask(image);
            if (colorKeyMask != null) {
                pdImage.cosGetDict().put(PDImage.DK_Mask, colorKeyMask);
            } else {
                pdImage.setMask((PDXObject)this.computeStencil(image));
            }
        } else if (transparency == 3) {
            pdImage.setSMask((PDXObject)this.computeSoftMask(image));
        }
        return pdImage;
    }

    public PDImage createJpegPDImage(BufferedImage image, float quality) throws IOException {
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException("quality must be between 0 and 1!");
        }
        BufferedImage colorComponents = this.stripAlphaChannel(image);
        byte[] jpegData = this.encodeAsJpeg(colorComponents, quality);
        PDImage pdImage = this.createPDImageFromJpeg(colorComponents, jpegData);
        int transparency = image.getColorModel().getTransparency();
        if (transparency == 2) {
            pdImage.setMask((PDXObject)this.computeStencil(image));
        } else if (transparency == 3) {
            pdImage.setSMask((PDXObject)this.computeSoftMask(image));
        }
        return pdImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage stripAlphaChannel(BufferedImage image) {
        IndexColorModel indexColorModel;
        int transparentPixel;
        ColorModel colorModel = image.getColorModel();
        if (!colorModel.hasAlpha()) {
            return image;
        }
        Color transparentBackground = Color.WHITE;
        if (colorModel instanceof IndexColorModel && (transparentPixel = (indexColorModel = (IndexColorModel)colorModel).getTransparentPixel()) != -1) {
            transparentBackground = new Color(indexColorModel.getRGB(transparentPixel));
        }
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D graphics = copy.createGraphics();
        try {
            graphics.drawImage(image, 0, 0, transparentBackground, null);
        }
        finally {
            graphics.dispose();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodeAsJpeg(BufferedImage image, float quality) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(JPEG_FORMAT_NAME);
        if (!writers.hasNext()) {
            throw new IIOException("no JPEG image writer available");
        }
        JPEGImageWriteParam writeParameters = new JPEGImageWriteParam(null);
        writeParameters.setCompressionMode(2);
        writeParameters.setCompressionQuality(quality);
        ImageWriter writer = writers.next();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(output);){
            writer.setOutput(imageOutputStream);
            writer.write(null, new IIOImage(image, null, null), writeParameters);
        }
        finally {
            writer.dispose();
        }
        return output.toByteArray();
    }

    private PDImage createGrayPDImage(BufferedImage image) {
        int bitsPerComponent = image.getColorModel().getPixelSize();
        byte[] data = this.getPackedBinaryData(image);
        return this.newPDImage((PDColorSpace)PDCSDeviceGray.SINGLETON, image.getWidth(), image.getHeight(), bitsPerComponent, data);
    }

    private PDImage createMonochromePDImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] data = this.getPackedBinaryData(image);
        if (this.isZeroBlack(image)) {
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = ~data[n];
            }
        }
        byte[] encodedData = this.encodeCCITT_T6(data, width, height);
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(width);
        pdImage.setHeight(height);
        pdImage.setBitsPerComponent(1);
        this.setColorSpace(pdImage, (PDColorSpace)PDCSDeviceGray.SINGLETON);
        COSDictionary filterParameters = COSDictionary.create();
        filterParameters.put(CCITTFaxFilter.DK_K, (COSObject)COSInteger.create((int)-1));
        filterParameters.put(CCITTFaxFilter.DK_Columns, (COSObject)COSInteger.create((int)width));
        filterParameters.put(CCITTFaxFilter.DK_Rows, (COSObject)COSInteger.create((int)height));
        COSStream stream = pdImage.cosGetStream();
        stream.addFilter(Filter.CN_Filter_CCITTFaxDecode, filterParameters);
        stream.setEncodedBytes(encodedData);
        return pdImage;
    }

    private PDImage createRGBPDImage(BufferedImage image) {
        PDColorSpace pdColorSpace = this.toPDColorSpace(image.getColorModel());
        byte[] data = this.getRGBData(image);
        return this.newPDImage(pdColorSpace, image.getWidth(), image.getHeight(), 8, data);
    }

    private PDImage createIndexedPDImage(BufferedImage image) {
        IndexColorModel colorModel = (IndexColorModel)image.getColorModel();
        PDColorSpace pdColorSpace = this.toPDColorSpace(colorModel);
        int bitsPerComponent = image.getColorModel().getPixelSize();
        byte[] data = this.getPackedBinaryData(image);
        return this.newPDImage(pdColorSpace, image.getWidth(), image.getHeight(), bitsPerComponent, data);
    }

    private PDImage newPDImage(PDColorSpace pdColorSpace, int width, int height, int bitsPerComponent, byte[] data) {
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(width);
        pdImage.setHeight(height);
        pdImage.setBitsPerComponent(bitsPerComponent);
        this.setColorSpace(pdImage, pdColorSpace);
        COSStream stream = pdImage.cosGetStream();
        stream.addFilter(Filter.CN_Filter_FlateDecode);
        stream.setDecodedBytes(data);
        return pdImage;
    }

    private byte[] getRGBData(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] data = new byte[width * height * 3];
        int offset = 0;
        int[] row = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getRGB(0, y, width, 1, row, 0, width);
            for (int pixel : row) {
                data[offset++] = (byte)(pixel >> 16 & 0xFF);
                data[offset++] = (byte)(pixel >> 8 & 0xFF);
                data[offset++] = (byte)(pixel & 0xFF);
            }
        }
        return data;
    }

    private byte[] getPackedBinaryData(BufferedImage image) {
        byte[] bufferData;
        int width = image.getWidth();
        int height = image.getHeight();
        int bitsPerPixel = image.getColorModel().getPixelSize();
        int bytesPerRow = (width * bitsPerPixel + 7) / 8;
        WritableRaster raster = image.getRaster();
        if (raster.getTransferType() == 0 && (bufferData = ((DataBufferByte)raster.getDataBuffer()).getData()).length == height * bytesPerRow) {
            return bufferData;
        }
        byte[] data = new byte[height * bytesPerRow];
        int index = 0;
        int[] samples = new int[width];
        for (int y = 0; y < height; ++y) {
            int x;
            raster.getPixels(0, y, width, 1, samples);
            switch (bitsPerPixel) {
                case 1: {
                    int last = width & 0xFFFFFFF8;
                    for (x = 0; x < last; x += 8) {
                        data[index++] = (byte)((samples[x] & 1) << 7 | (samples[x + 1] & 1) << 6 | (samples[x + 2] & 1) << 5 | (samples[x + 3] & 1) << 4 | (samples[x + 4] & 1) << 3 | (samples[x + 5] & 1) << 2 | (samples[x + 6] & 1) << 1 | samples[x + 7] & 1);
                    }
                    break;
                }
                case 2: {
                    int last = width & 0xFFFFFFFC;
                    while (x < last) {
                        data[index++] = (byte)((samples[x] & 3) << 6 | (samples[x + 1] & 3) << 4 | (samples[x + 2] & 3) << 2 | samples[x + 3] & 3);
                        x += 4;
                    }
                    break;
                }
                case 4: {
                    int last = width & 0xFFFFFFFE;
                    while (x < last) {
                        data[index++] = (byte)((samples[x] & 7) << 4 | samples[x + 1] & 7);
                        x += 2;
                    }
                    break;
                }
                case 8: {
                    int last = width;
                    while (x < last) {
                        data[index++] = (byte)samples[x];
                        ++x;
                    }
                    break;
                }
            }
            int bitOffset = 0;
            int mask = (1 << bitsPerPixel) - 1;
            long value = 0L;
            while (x < width) {
                value = value << bitsPerPixel | (long)(samples[x] & mask);
                bitOffset += bitsPerPixel;
                while (bitOffset >= 8) {
                    data[index++] = (byte)(value >>> bitOffset - 8);
                    bitOffset -= 8;
                }
                ++x;
            }
            if (bitOffset <= 0) continue;
            data[index++] = (byte)(value << 8 - bitOffset);
        }
        return data;
    }

    private byte[] encodeCCITT_T6(byte[] data, int width, int height) {
        int rowStride = (width + 7) / 8;
        int maxBitsPerRow = 9 * ((width + 1) / 2) + 2;
        int maxBytesPerRow = (maxBitsPerRow + 7) / 8;
        int bufferSize = height * (maxBytesPerRow + 2) + 12;
        TIFFT6Compressor compressor = new TIFFT6Compressor();
        byte[] encodedData = new byte[bufferSize];
        int encodedLength = compressor.encodeT6(data, rowStride, 0, width, height, encodedData);
        return Arrays.copyOf(encodedData, encodedLength);
    }

    private PDImage computeStencil(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int bytesPerRow = (width + 7) / 8;
        byte[] data = new byte[height * bytesPerRow];
        int index = 0;
        int[] argb = new int[width];
        for (int y = 0; y < height; ++y) {
            int x;
            image.getRGB(0, y, width, 1, argb, 0, width);
            int last = width & 0xFFFFFFF8;
            for (x = 0; x < last; x += 8) {
                data[index++] = (byte)(~(argb[x] >> 17 & 0x80 | argb[x + 1] >> 18 & 0x40 | argb[x + 2] >> 19 & 0x20 | argb[x + 3] >> 20 & 0x10 | argb[x + 4] >> 21 & 8 | argb[x + 5] >> 22 & 4 | argb[x + 6] >> 23 & 2 | argb[x + 7] >> 24 & 1));
            }
            int remainingBits = width - x;
            if (remainingBits <= 0) continue;
            int value = 0;
            while (x < width) {
                value = value << 1 | argb[x] >> 24 & 1;
                ++x;
            }
            data[index++] = (byte)(~(value << 8 - remainingBits));
        }
        PDImage stencil = this.newPDImage(null, width, height, 1, data);
        stencil.setImageMask(true);
        return stencil;
    }

    private PDImage computeSoftMask(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] data = new byte[height * width];
        int index = 0;
        int[] argb = new int[width];
        for (int y = 0; y < height; ++y) {
            image.getRGB(0, y, width, 1, argb, 0, width);
            for (int x = 0; x < width; ++x) {
                data[index++] = (byte)(argb[x] >> 24);
            }
        }
        return this.newPDImage((PDColorSpace)PDCSDeviceGray.SINGLETON, width, height, 8, data);
    }

    private COSObject computeColorKeyMask(BufferedImage image) {
        int last;
        int first;
        if (!this.isIndexed(image)) {
            return null;
        }
        IndexColorModel colorModel = (IndexColorModel)image.getColorModel();
        int mapSize = colorModel.getMapSize();
        byte[] alphas = new byte[mapSize];
        colorModel.getAlphas(alphas);
        for (first = 0; first < mapSize && alphas[first] != 0; ++first) {
        }
        if (first == mapSize) {
            return null;
        }
        for (last = mapSize - 1; last > first && alphas[last] != 0; --last) {
        }
        for (int i = first + 1; i < last; ++i) {
            if (alphas[i] == 0) continue;
            return null;
        }
        COSArray mask = COSArray.create((int)2);
        mask.add((COSObject)COSInteger.create((int)first));
        mask.add((COSObject)COSInteger.create((int)last));
        return mask;
    }

    private PDColorSpace toPDColorSpace(IndexColorModel colorModel) {
        int mapSize = colorModel.getMapSize();
        int[] rgbs = new int[mapSize];
        colorModel.getRGBs(rgbs);
        byte[] colorMap = new byte[mapSize * 3];
        for (int i = 0; i < mapSize; ++i) {
            colorMap[i * 3] = (byte)(rgbs[i] >> 16);
            colorMap[i * 3 + 1] = (byte)(rgbs[i] >> 8);
            colorMap[i * 3 + 2] = (byte)rgbs[i];
        }
        COSStream lookup = COSStream.create(null);
        lookup.setDecodedBytes(colorMap);
        COSArray cosColorSpace = COSArray.create((int)4);
        cosColorSpace.add((COSObject)PDColorSpace.CN_CS_Indexed);
        cosColorSpace.add((COSObject)PDColorSpace.CN_CS_DeviceRGB);
        cosColorSpace.add((COSObject)COSInteger.create((int)(mapSize - 1)));
        cosColorSpace.add((COSObject)lookup);
        return (PDColorSpace)PDCSIndexed.META.createFromCos((COSObject)cosColorSpace);
    }

    private PDColorSpace toPDColorSpace(ColorModel colorModel) {
        if (colorModel.getNumColorComponents() == 1) {
            return PDCSDeviceGray.SINGLETON;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace.isCS_sRGB()) {
            return PDCSDeviceRGB.SINGLETON;
        }
        if (colorSpace.equals(ColorSpace.getInstance(1003))) {
            return PDCSDeviceGray.SINGLETON;
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            return this.toPDColorSpace((ICC_ColorSpace)colorSpace);
        }
        switch (colorSpace.getType()) {
            case 6: {
                return PDCSDeviceGray.SINGLETON;
            }
            case 5: {
                return PDCSDeviceRGB.SINGLETON;
            }
            case 9: {
                return PDCSDeviceCMYK.SINGLETON;
            }
        }
        throw new UnsupportedOperationException("unsupported color space: " + colorSpace.getType());
    }

    private PDColorSpace toPDColorSpace(ICC_ColorSpace colorSpace) {
        int componentCount = colorSpace.getNumComponents();
        COSArray range = COSArray.create((int)(2 * componentCount));
        for (int i = 0; i < componentCount; ++i) {
            range.add((COSObject)COSFixed.create((float)colorSpace.getMinValue(i)));
            range.add((COSObject)COSFixed.create((float)colorSpace.getMaxValue(i)));
        }
        COSStream profileStream = COSStream.create(null);
        profileStream.getDict().put(PDCSICCBased.DK_N, (COSObject)COSInteger.create((int)componentCount));
        profileStream.getDict().put(DK_Range, (COSObject)range);
        profileStream.addFilter(Filter.CN_Filter_FlateDecode);
        profileStream.setDecodedBytes(colorSpace.getProfile().getData());
        COSArray cosColorSpace = COSArray.create((int)2);
        cosColorSpace.add((COSObject)PDColorSpace.CN_CS_ICCBased);
        cosColorSpace.add((COSObject)profileStream);
        return (PDColorSpace)PDCSICCBased.META.createFromCos((COSObject)cosColorSpace);
    }

    private void setColorSpace(PDImage image, PDColorSpace colorSpace) {
        image.setFieldObject(PDImage.DK_ColorSpace, (COSBasedObject)colorSpace);
    }

    private boolean isGray(BufferedImage image) {
        return image.getType() == 10 && image.getColorModel().getPixelSize() <= 8;
    }

    private boolean isMonochrome(BufferedImage image) {
        return image.getType() == 12 && image.getColorModel().getPixelSize() == 1;
    }

    private boolean isZeroBlack(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        return (colorModel.getRGB(0) & 0xFFFFFF) == 0;
    }

    private boolean isIndexed(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        return colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getMapSize() <= 256;
    }
}

