/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.app.observer.common.PagesWatchdog;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import java.util.Iterator;

public abstract class AnnotationsWatchdog
extends PagesWatchdog {
    private ICOSObjectListener annotationsArrayListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            AnnotationsWatchdog.this.onAnnotationsArrayChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener annotationListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            AnnotationsWatchdog.this.onAnnotationChanged(object, slot, oldValue, newValue);
        }
    };

    public AnnotationsWatchdog(COSDocument doc) {
        super(doc);
    }

    public AnnotationsWatchdog(PDDocument pdDoc) {
        super(pdDoc);
    }

    @Override
    protected void addPageNodeListeners(COSDictionary node) {
        super.addPageNodeListeners(node);
        if (node == null) {
            return;
        }
        COSArray co = node.get(PDPage.DK_Annots).asArray();
        this.addAnnotationsArrayListeners(co);
    }

    @Override
    protected void removePageNodeListeners(COSDictionary node) {
        super.removePageNodeListeners(node);
        if (node == null) {
            return;
        }
        COSArray co = node.get(PDPage.DK_Annots).asArray();
        this.removeAnnotationsArrayListeners(co);
    }

    @Override
    protected void basicPageNodeEntryChanged(COSObject field, Object slot, Object oldValue, Object newValue) {
        if (PDPage.DK_Annots.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removeAnnotationsArrayListeners(((COSObject)oldValue).asArray());
            }
            if (newValue instanceof COSObject) {
                this.addAnnotationsArrayListeners(((COSObject)newValue).asArray());
            }
            this.basicAnnotationsChanged();
        }
        super.basicPageNodeEntryChanged(field, slot, oldValue, newValue);
    }

    protected final void onAnnotationsArrayChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (oldValue instanceof COSObject) {
            this.removeAnnotationListeners(((COSObject)oldValue).asDictionary());
        }
        if (newValue instanceof COSObject) {
            this.addAnnotationListeners(((COSObject)newValue).asDictionary());
        }
        this.basicAnnotationsChanged();
    }

    protected void basicAnnotationsChanged() {
    }

    protected void addAnnotationsArrayListeners(COSArray annotations) {
        if (annotations == null) {
            return;
        }
        annotations.addObjectListener(this.annotationsArrayListener);
        Iterator i = annotations.iterator();
        while (i.hasNext()) {
            COSDictionary annotation = ((COSObject)i.next()).asDictionary();
            this.addAnnotationListeners(annotation);
        }
    }

    protected void removeAnnotationsArrayListeners(COSArray annotations) {
        if (annotations == null) {
            return;
        }
        annotations.removeObjectListener(this.annotationsArrayListener);
        Iterator i = annotations.iterator();
        while (i.hasNext()) {
            COSDictionary annotation = ((COSObject)i.next()).asDictionary();
            this.removeAnnotationListeners(annotation);
        }
    }

    protected void addAnnotationListeners(COSDictionary annotation) {
        if (annotation == null) {
            return;
        }
        annotation.addObjectListener(this.annotationListener);
    }

    protected final void onAnnotationChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        this.basicAnnotationChanged(object, slot, oldValue, newValue);
    }

    protected void removeAnnotationListeners(COSDictionary annotation) {
        if (annotation == null) {
            return;
        }
        annotation.removeObjectListener(this.annotationListener);
    }

    protected void basicAnnotationChanged(COSObject annotation, Object slot, Object oldValue, Object newValue) {
    }
}

