/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.app.observer.COSAspectWatchdog;
import de.intarsys.pdf.app.observer.COSStructureWatchdog;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSObjectListener;

public abstract class EmbeddedFilesWatchdog
extends COSStructureWatchdog {
    private ICOSObjectListener listenCatalogChange = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            EmbeddedFilesWatchdog.this.changedCatalog(object);
        }
    };
    private ICOSObjectListener listenEmbeddedFilesChange = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            EmbeddedFilesWatchdog.this.changedEmbeddedFiles();
        }
    };

    public EmbeddedFilesWatchdog() {
        this.buildWatchdogs();
    }

    protected void basicStart() {
        super.basicStart();
    }

    protected void buildWatchdogs() {
        COSAspectWatchdog catalogNamesWatchdog = this.watch(COSCatalog.DK_Names, this.listenCatalogChange);
        COSAspectWatchdog embeddedFilesRootWatchdog = catalogNamesWatchdog.watch((Object)COSCatalog.DK_EmbeddedFiles, this.listenEmbeddedFilesChange);
        COSAspectWatchdog namesWatchdog = embeddedFilesRootWatchdog.watch((Object)CDSNameTreeNode.DK_Names, this.listenEmbeddedFilesChange);
        namesWatchdog.watch(null, this.listenEmbeddedFilesChange);
    }

    protected void changedCatalog(COSObject object) {
    }

    protected void changedEmbeddedFiles() {
    }

    public void setDocument(COSDocument cosDoc) {
        this.setWatched(cosDoc.getCatalog().cosGetObject());
    }

    class TreeNodeWatchdog
    extends COSAspectWatchdog {
        public TreeNodeWatchdog(Object slot, ICOSObjectListener listener) {
            super(slot, listener);
        }

        public void setWatched(Object pWatched) {
            super.setWatched(pWatched);
            this.clearChildWatchdogs();
            this.watch(CDSNameTreeNode.DK_Names, EmbeddedFilesWatchdog.this.listenEmbeddedFilesChange);
            COSAspectWatchdog kidsWatchdog = this.watch(CDSNameTreeNode.DK_Kids, EmbeddedFilesWatchdog.this.listenEmbeddedFilesChange);
            TreeNodeWatchdog embeddedFilesChildWatchdog = new TreeNodeWatchdog(null, null);
            kidsWatchdog.addChildWatchdog((COSAspectWatchdog)embeddedFilesChildWatchdog);
        }
    }
}

