/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.component.IStartStop;
import java.util.Iterator;
import java.util.Set;

public abstract class FormWatchdog
implements IStartStop {
    private COSDocument doc;
    private boolean started = false;
    private ICOSObjectListener catalogListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            FormWatchdog.this.onCatalogChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener formListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            FormWatchdog.this.onFormChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener fieldArrayListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            FormWatchdog.this.onFieldArrayChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener fieldListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            FormWatchdog.this.onFieldChanged(object, slot, oldValue, newValue);
        }
    };

    public FormWatchdog(COSDocument doc) {
        this.doc = doc;
    }

    public FormWatchdog(PDDocument pdDoc) {
        if (pdDoc != null) {
            this.doc = pdDoc.cosGetDoc();
        }
    }

    protected void addDocListeners(COSDocument pDoc) {
        COSCatalog catalog = pDoc.getCatalog();
        if (catalog == null) {
            return;
        }
        catalog.cosGetDict().addObjectListener(this.catalogListener);
        COSDictionary form = catalog.cosGetField(COSCatalog.DK_AcroForm).asDictionary();
        this.addFormListeners(form);
    }

    protected void addFieldArrayListeners(COSArray fields) {
        if (fields == null) {
            return;
        }
        fields.addObjectListener(this.fieldArrayListener);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            COSDictionary field = ((COSObject)i.next()).asDictionary();
            this.addFieldListeners(field);
        }
    }

    protected void addFieldListeners(COSDictionary field) {
        if (field == null) {
            return;
        }
        field.addObjectListener(this.fieldListener);
        COSArray kids = field.get(PDAcroFormField.DK_Kids).asArray();
        this.addFieldArrayListeners(kids);
    }

    protected void addFormListeners(COSDictionary formDict) {
        if (formDict == null) {
            return;
        }
        formDict.addObjectListener(this.formListener);
        COSArray fields = formDict.get(PDAcroForm.DK_Fields).asArray();
        this.addFieldArrayListeners(fields);
    }

    protected void basicFieldEntryChanged(COSObject field, Object slot, Object oldValue, Object newValue) {
    }

    protected void basicFormEntryChanged(COSObject form, Object slot, Object oldValue, Object newValue) {
    }

    protected void basicFormStructureChanged() {
    }

    public COSDocument getDoc() {
        return this.doc;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected final void onCatalogChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (slot == null || COSCatalog.DK_AcroForm.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removeFormListeners(((COSObject)oldValue).asDictionary());
            }
            if (newValue instanceof COSObject) {
                this.addFormListeners(((COSObject)newValue).asDictionary());
            }
            this.basicFormStructureChanged();
        }
    }

    protected final void onFieldArrayChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (oldValue instanceof COSObject) {
            this.removeFieldListeners(((COSObject)oldValue).asDictionary());
        }
        if (newValue instanceof COSObject) {
            this.addFieldListeners(((COSObject)newValue).asDictionary());
        }
        this.basicFormStructureChanged();
    }

    protected final void onFieldChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (PDAcroFormField.DK_Kids.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removeFieldArrayListeners(((COSObject)oldValue).asArray());
            }
            if (newValue instanceof COSObject) {
                this.addFieldArrayListeners(((COSObject)newValue).asArray());
            }
            this.basicFormStructureChanged();
        }
        this.basicFieldEntryChanged(object, slot, oldValue, newValue);
    }

    protected final void onFormChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (slot == null || PDAcroForm.DK_Fields.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removeFieldArrayListeners(((COSObject)oldValue).asArray());
            }
            if (newValue instanceof COSObject) {
                this.addFieldArrayListeners(((COSObject)newValue).asArray());
            }
            this.basicFormStructureChanged();
        }
        this.basicFormEntryChanged(object, slot, oldValue, newValue);
    }

    protected void removeDocListeners(COSDocument pDoc) {
        COSCatalog catalog = pDoc.getCatalog();
        if (catalog == null) {
            return;
        }
        catalog.cosGetDict().removeObjectListener(this.catalogListener);
        COSDictionary form = catalog.cosGetField(COSCatalog.DK_AcroForm).asDictionary();
        this.removeFormListeners(form);
    }

    protected void removeFieldArrayListeners(COSArray fields) {
        if (fields == null) {
            return;
        }
        fields.removeObjectListener(this.fieldArrayListener);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            COSDictionary field = ((COSObject)i.next()).asDictionary();
            this.removeFieldListeners(field);
        }
    }

    protected void removeFieldListeners(COSDictionary field) {
        if (field == null) {
            return;
        }
        field.removeObjectListener(this.fieldListener);
        COSArray kids = field.get(PDAcroFormField.DK_Kids).asArray();
        this.removeFieldArrayListeners(kids);
    }

    protected void removeFormListeners(COSDictionary formDict) {
        if (formDict == null) {
            return;
        }
        formDict.removeObjectListener(this.formListener);
        COSArray fields = formDict.get(PDAcroForm.DK_Fields).asArray();
        this.removeFieldArrayListeners(fields);
    }

    public void start() {
        this.started = true;
        if (this.getDoc() == null) {
            return;
        }
        this.addDocListeners(this.getDoc());
    }

    public void stop() {
        this.started = false;
        if (this.getDoc() == null) {
            return;
        }
        this.removeDocListeners(this.getDoc());
    }

    public boolean stopRequested(Set visited) {
        return true;
    }
}

