/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.app.observer.COSAspectWatchdog;
import de.intarsys.pdf.app.observer.COSStructureWatchdog;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import java.util.ArrayList;

public abstract class OutlineWatchdog
extends COSStructureWatchdog {
    private ICOSObjectListener listenCatalogChange = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            OutlineWatchdog.this.changedCatalog(object);
        }
    };
    private ICOSObjectListener listenOutlineChange = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            OutlineWatchdog.this.changedOutline(object);
        }
    };

    protected void changedOutline(COSObject object) {
    }

    protected void changedCatalog(COSObject object) {
    }

    public OutlineWatchdog() {
        this.buildWatchdogs();
    }

    public void setDocument(COSDocument cosDoc) {
        this.setWatched(cosDoc.getCatalog().cosGetObject());
    }

    protected void buildWatchdogs() {
        COSAspectWatchdog catalogOutlinesWatchdog = this.watch(COSCatalog.DK_Outlines, this.listenCatalogChange);
        COSAspectWatchdog outlineRootWatchdog = catalogOutlinesWatchdog.watch((Object)PDOutlineNode.DK_First, this.listenOutlineChange);
        OutlineItemsWatchdog outlineItemsWatchdog = new OutlineItemsWatchdog(null, null);
        outlineRootWatchdog.addChildWatchdog((COSAspectWatchdog)outlineItemsWatchdog);
    }

    class OutlineItemsWatchdog
    extends COSAspectWatchdog {
        private ICOSObjectListener listenLinkedListChange;

        public OutlineItemsWatchdog(Object slot, ICOSObjectListener listener) {
            super(slot, listener);
            this.listenLinkedListChange = new ICOSObjectListener(){

                public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
                    COSObject changedOutline;
                    if (object instanceof COSDictionary && !(changedOutline = ((COSDictionary)object).get(PDOutlineItem.DK_Parent)).isNull()) {
                        OutlineWatchdog.this.changedOutline(changedOutline);
                    }
                    OutlineItemsWatchdog.this.restartParent();
                }
            };
        }

        protected Object expand(COSObject object) {
            ArrayList<COSDictionary> result = new ArrayList<COSDictionary>();
            COSDictionary outlineItemDict = object.asDictionary();
            while (outlineItemDict != null) {
                result.add(outlineItemDict);
                outlineItemDict = outlineItemDict.get(PDOutlineItem.DK_Next).asDictionary();
            }
            return result;
        }

        public void setWatched(Object pWatched) {
            super.setWatched(pWatched);
            this.clearChildWatchdogs();
            this.watch(PDOutlineItem.DK_Next, this.listenLinkedListChange);
            this.watch(PDOutlineItem.DK_Title, OutlineWatchdog.this.listenOutlineChange);
            this.watch(PDOutlineItem.DK_C, OutlineWatchdog.this.listenOutlineChange);
            this.watch(PDOutlineItem.DK_A, OutlineWatchdog.this.listenOutlineChange);
            COSAspectWatchdog outlineRootWatchdog = this.watch(PDOutlineNode.DK_First, OutlineWatchdog.this.listenOutlineChange);
            OutlineItemsWatchdog outlineItemsWatchdog = new OutlineItemsWatchdog(null, null);
            outlineRootWatchdog.addChildWatchdog((COSAspectWatchdog)outlineItemsWatchdog);
        }
    }
}

