/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.app.observer.COSAspectWatchdog;
import de.intarsys.pdf.app.observer.COSStructureWatchdog;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDPage;

public abstract class PageAnnotationWatchdog
extends COSStructureWatchdog {
    private ICOSObjectListener listenPageAnnots = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PageAnnotationWatchdog.this.onPageAnnotsChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener listenAnnotations = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PageAnnotationWatchdog.this.onAnnotationsChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener listenAnnotationAppearance = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PageAnnotationWatchdog.this.onAnnotationChanged(object, slot, oldValue, newValue);
        }
    };

    public PageAnnotationWatchdog() {
        this.buildWatchdogs();
    }

    protected void buildWatchdogs() {
        COSAspectWatchdog pageAnnotsWatchdog = this.watch(PDPage.DK_Annots, this.listenPageAnnots);
        COSAspectWatchdog annotationsWatchdog = pageAnnotsWatchdog.watch(null, this.listenAnnotations);
        COSAspectWatchdog annotationAPWatchdog = annotationsWatchdog.watch((Object)PDAnnotation.DK_AP, this.listenAnnotationAppearance);
        COSAspectWatchdog annotationASWatchdog = annotationsWatchdog.watch((Object)PDAnnotation.DK_AS, this.listenAnnotationAppearance);
        COSAspectWatchdog fieldFlagsWatchdog = annotationsWatchdog.watch((Object)PDAcroFormField.DK_Ff, this.listenAnnotationAppearance);
        COSAspectWatchdog annotationFlagsWatchdog = annotationsWatchdog.watch((Object)PDAnnotation.DK_F, this.listenAnnotationAppearance);
        COSAspectWatchdog annotationRectWatchdog = annotationsWatchdog.watch((Object)PDAnnotation.DK_Rect, this.listenAnnotationAppearance);
    }

    protected void changed(PDAnnotation annot) {
    }

    protected void changed(PDAnnotation annot, Object slot, Object oldValue, Object newValue) {
        this.changed(annot);
    }

    protected void changedAnnotations() {
    }

    protected final void onAnnotationChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        PDAnnotation annot = (PDAnnotation)PDAnnotation.META.createFromCos(object);
        this.changed(annot, slot, oldValue, newValue);
    }

    protected final void onAnnotationsChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        this.changedAnnotations();
    }

    protected final void onPageAnnotsChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        this.changedAnnotations();
    }

    public void setPage(PDPage page) {
        this.setWatched(page.cosGetObject());
    }
}

