/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer.common;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.tools.component.IStartStop;
import java.util.Iterator;
import java.util.Set;

public abstract class PagesWatchdog
implements IStartStop {
    private COSDocument doc;
    private boolean started = false;
    private ICOSObjectListener catalogListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PagesWatchdog.this.onCatalogChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener pageNodeListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PagesWatchdog.this.onPageNodeChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSObjectListener pageNodeArrayListener = new ICOSObjectListener(){

        public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
            PagesWatchdog.this.onPageNodeArrayChanged(object, slot, oldValue, newValue);
        }
    };
    private ICOSDocumentListener documentListener = new ICOSDocumentListener(){

        public void changed(COSDocument document, Object slot, Object oldValue, Object newValue) {
            PagesWatchdog.this.onDocumentChanged(slot, oldValue, newValue);
        }
    };

    public PagesWatchdog(COSDocument doc) {
        this.doc = doc;
    }

    public PagesWatchdog(PDDocument pdDoc) {
        if (pdDoc != null) {
            this.doc = pdDoc.cosGetDoc();
        }
    }

    protected void addDocListeners(COSDocument pDoc) {
        COSCatalog catalog = pDoc.getCatalog();
        if (catalog == null) {
            return;
        }
        pDoc.addDocumentListener(this.documentListener);
        catalog.cosGetDict().addObjectListener(this.catalogListener);
        COSDictionary node = catalog.cosGetField(COSCatalog.DK_Pages).asDictionary();
        this.addPageNodeListeners(node);
    }

    protected void addPageNodeArrayListeners(COSArray nodes) {
        if (nodes == null) {
            return;
        }
        nodes.addObjectListener(this.pageNodeArrayListener);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            COSDictionary node = ((COSObject)i.next()).asDictionary();
            this.addPageNodeListeners(node);
        }
    }

    protected void addPageNodeListeners(COSDictionary node) {
        if (node == null) {
            return;
        }
        node.addObjectListener(this.pageNodeListener);
        COSArray kids = node.get(PDPageTree.DK_Kids).asArray();
        this.addPageNodeArrayListeners(kids);
    }

    protected void basicPageNodeEntryChanged(COSObject pageNode, Object slot, Object oldValue, Object newValue) {
    }

    protected void basicPageTreeChanged() {
    }

    public COSDocument getDoc() {
        return this.doc;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected final void onCatalogChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (slot == null || COSCatalog.DK_Pages.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removePageNodeListeners(((COSObject)oldValue).asDictionary());
            }
            if (newValue instanceof COSObject) {
                this.addPageNodeListeners(((COSObject)newValue).asDictionary());
            }
            this.basicPageTreeChanged();
        }
    }

    protected void onDocumentChanged(Object slot, Object oldValue, Object newValue) {
        if (slot == COSDocument.SLOT_ALL) {
            this.basicPageTreeChanged();
        }
    }

    protected final void onPageNodeArrayChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (oldValue instanceof COSObject) {
            this.removePageNodeListeners(((COSObject)oldValue).asDictionary());
        }
        if (newValue instanceof COSObject) {
            this.addPageNodeListeners(((COSObject)newValue).asDictionary());
        }
        this.basicPageTreeChanged();
    }

    protected final void onPageNodeChanged(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (slot == null || PDPageTree.DK_Kids.equals(slot)) {
            if (oldValue instanceof COSObject) {
                this.removePageNodeArrayListeners(((COSObject)oldValue).asArray());
            }
            if (newValue instanceof COSObject) {
                this.addPageNodeArrayListeners(((COSObject)newValue).asArray());
            }
            this.basicPageTreeChanged();
        }
        this.basicPageNodeEntryChanged(object, slot, oldValue, newValue);
    }

    protected void removeDocListeners(COSDocument pDoc) {
        COSCatalog catalog = pDoc.getCatalog();
        if (catalog == null) {
            return;
        }
        pDoc.removeDocumentListener(this.documentListener);
        catalog.cosGetDict().removeObjectListener(this.catalogListener);
        COSDictionary node = catalog.cosGetField(COSCatalog.DK_Pages).asDictionary();
        this.removePageNodeListeners(node);
    }

    protected void removePageNodeArrayListeners(COSArray nodes) {
        if (nodes == null) {
            return;
        }
        nodes.removeObjectListener(this.pageNodeArrayListener);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            COSDictionary node = ((COSObject)i.next()).asDictionary();
            this.removePageNodeListeners(node);
        }
    }

    protected void removePageNodeListeners(COSDictionary node) {
        if (node == null) {
            return;
        }
        node.removeObjectListener(this.pageNodeListener);
        COSArray kids = node.get(PDPageTree.DK_Kids).asArray();
        this.removePageNodeArrayListeners(kids);
    }

    public void start() {
        this.started = true;
        if (this.getDoc() == null) {
            return;
        }
        this.addDocListeners(this.getDoc());
    }

    public void stop() {
        this.started = false;
        if (this.getDoc() == null) {
            return;
        }
        this.removeDocListeners(this.getDoc());
    }

    public boolean stopRequested(Set visited) {
        return true;
    }
}

