/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.tags;

import de.intarsys.pdf.content.text.CSCharacterParser;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSTagDetector
extends CSCharacterParser {
    private static final String META_SEPARATOR = ".";
    private static final String META_PREFIX = "meta.";
    public static final String SYNTAX_DEFAULT = null;
    public static final String SYNTAX_PREFIXED = "prefixed";
    public static final String SYNTAX_SEPARATED = "separated";
    private static final Logger Log = LoggerFactory.getLogger(CSTagDetector.class);
    private char[] endTag = new char[]{'@', '@'};
    private final StringBuilder token = new StringBuilder();
    private Rectangle2D tagRect;
    private boolean tagActive = false;
    private boolean tagCaseSensitive = true;
    private final List<Tag> tags = new ArrayList<Tag>();
    private String tagSyntax;
    private double maxDX = 5.0;
    private double maxDY = 5.0;
    private int prefixLength = 2;
    private char[] startTag = new char[]{'@', '@'};
    private int tagIndex = 0;
    private final Map<String, String> staticMetaInformation = new HashMap<String, String>();

    protected Tag addTag(String tagKey, String tagValue) {
        Log.trace("found tag " + tagKey + "=" + tagValue);
        Tag tag = new Tag(tagKey, tagValue);
        this.tags.add(tag);
        return tag;
    }

    protected void addTagMeta(Tag tag, String key, String value) {
        tag.setProperty(key, (Object)value);
        this.addTag(META_PREFIX + tag.getKey() + META_SEPARATOR + key, value);
    }

    protected void addTagMetaStatic(Tag tag) {
        for (Map.Entry<String, String> entry : this.staticMetaInformation.entrySet()) {
            this.addTagMeta(tag, entry.getKey(), entry.getValue());
        }
    }

    protected void check(char c, Rectangle2D rect) {
        if (this.tagActive) {
            this.tagRect.add(rect);
            if (c == this.endTag[this.tagIndex]) {
                ++this.tagIndex;
                if (this.tagIndex == this.endTag.length) {
                    this.tagIndex = 0;
                    this.tagActive = false;
                    this.consumeTag();
                    this.tagRect = null;
                }
            } else {
                if (this.tagIndex > 0) {
                    this.token.append(this.endTag, 0, this.tagIndex);
                    this.tagIndex = 0;
                }
                this.token.append(c);
            }
        } else if (c == this.startTag[this.tagIndex]) {
            if (this.tagRect == null) {
                this.tagRect = (Rectangle2D)rect.clone();
            } else {
                this.tagRect.add(rect);
            }
            ++this.tagIndex;
            if (this.tagIndex == this.startTag.length) {
                this.tagIndex = 0;
                this.tagActive = true;
                this.token.setLength(0);
            }
        } else {
            this.tagIndex = 0;
            this.tagRect = null;
        }
    }

    protected void check(char[] chars, Rectangle2D rect) {
        for (int i = 0; i < chars.length; ++i) {
            this.check(chars[i], rect);
        }
    }

    public void clearTags() {
        this.tags.clear();
    }

    protected void consumeTag() {
        String value;
        String key;
        if (SYNTAX_SEPARATED.equals(this.getTagSyntax())) {
            try {
                Tag tempTag = TagTools.parseTag((String)this.token.toString());
                key = tempTag.getKey();
                value = tempTag.getValue();
            }
            catch (IOException e) {
                Log.warn("tag cannot be parsed {}", (Object)this.token);
                return;
            }
        } else if (this.token.length() >= this.getPrefixLength()) {
            key = this.token.substring(0, this.getPrefixLength());
            value = this.token.substring(this.getPrefixLength());
        } else {
            key = this.token.toString();
            value = "";
        }
        if (!this.isTagCaseSensitive()) {
            key = key.toLowerCase(Locale.getDefault());
        }
        Log.debug("tag detection found {}={}", (Object)key, (Object)value);
        Tag tag = this.addTag(key, value);
        this.addTagMeta(tag, "llx", Integer.toString((int)this.tagRect.getMinX()));
        this.addTagMeta(tag, "lly", Integer.toString((int)this.tagRect.getMinY()));
        this.addTagMeta(tag, "urx", Integer.toString((int)this.tagRect.getMaxX()));
        this.addTagMeta(tag, "ury", Integer.toString((int)this.tagRect.getMaxY()));
        this.addTagMeta(tag, "width", Integer.toString((int)this.tagRect.getWidth()));
        this.addTagMeta(tag, "height", Integer.toString((int)this.tagRect.getHeight()));
        this.addTagMetaStatic(tag);
    }

    public char[] getEndTag() {
        return (char[])this.endTag.clone();
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public char[] getStartTag() {
        return (char[])this.startTag.clone();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getTagSyntax() {
        return this.tagSyntax;
    }

    public boolean isTagActive() {
        return this.tagActive;
    }

    public boolean isTagCaseSensitive() {
        return this.tagCaseSensitive;
    }

    protected void onCharacterFound(PDGlyphs glyphs, Rectangle2D rect) {
        char[] chars = glyphs.getChars();
        if (chars == null) {
            chars = new char[]{' '};
        }
        double dX = this.lastStopX - this.lastStartX;
        double dY = this.lastStopY - this.lastStartY;
        if (Math.abs(dX) < this.maxDX) {
            if (Math.abs(dY) > this.maxDY) {
                this.check(StringTools.LS.toCharArray(), rect);
            }
        } else if (Math.abs(dY) < this.maxDY) {
            this.check(' ', rect);
        } else {
            this.check(StringTools.LS.toCharArray(), rect);
        }
        this.check(chars, rect);
    }

    public void putMetaInformation(String key, String value) {
        this.staticMetaInformation.put(key, value);
    }

    public void setEndTag(char[] endTag) {
        this.endTag = (char[])endTag.clone();
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public void setStartTag(char[] startTag) {
        this.startTag = (char[])startTag.clone();
    }

    public void setTagActive(boolean value) {
        this.tagActive = value;
    }

    public void setTagCaseSensitive(boolean value) {
        this.tagCaseSensitive = value;
    }

    public void setTagSyntax(String value) {
        this.tagSyntax = value;
    }

    public void textSetFont(COSName name, PDFont font, float size) {
        super.textSetFont(name, font, size);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }

    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        super.textSetTransform(a, b, c, d, e, f);
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * tx.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * tx.getScaleY();
    }
}

