/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.tags;

import de.intarsys.pdf.app.tags.CSTagDetector;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.tag.Tag;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagDetector {
    private static final Logger Log = LoggerFactory.getLogger(TagDetector.class);
    private char[] endTag = new char[]{'@', '@'};
    private boolean keywordCaseSensitive = true;
    private String keywordSyntax;
    private int prefixLength = 2;
    private final List<Tag> keywords = new ArrayList<Tag>();
    private char[] startTag = new char[]{'@', '@'};
    private PDDocument document;

    public PDDocument getDocument() {
        return this.document;
    }

    public char[] getEndTag() {
        return (char[])this.endTag.clone();
    }

    public List<Tag> getKeywords() {
        return this.keywords;
    }

    public String getKeywordSyntax() {
        return this.keywordSyntax;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public char[] getStartTag() {
        return (char[])this.startTag.clone();
    }

    public boolean isKeywordCaseSensitive() {
        return this.keywordCaseSensitive;
    }

    public List<Tag> perform() {
        Log.debug("tag detector run, '{}'", (Object)this.getKeywordSyntax());
        CSTagDetector detector = new CSTagDetector();
        detector.setStartTag(this.getStartTag());
        detector.setEndTag(this.getEndTag());
        detector.setTagSyntax(this.getKeywordSyntax());
        detector.setPrefixLength(this.getPrefixLength());
        detector.setTagCaseSensitive(this.isKeywordCaseSensitive());
        PDPageTree pageTree = this.getDocument().getPageTree();
        this.processPageTree(pageTree, detector);
        Log.debug("tag detector finished, {} tags found", (Object)detector.getTags().size());
        this.getKeywords().addAll(detector.getTags());
        return this.getKeywords();
    }

    protected void processPage(PDPage page, CSTagDetector detector) {
        AffineTransform transform = PDFGeometryTools.createPageSpace((PDPage)page);
        detector.setDeviceTransform(transform);
        detector.putMetaInformation("page", Integer.toString(page.getNodeIndex()));
        CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, (ICSDevice)detector);
        try {
            interpreter.process(page.getContentStream(), page.getResources());
        }
        catch (CSException e) {
            Log.debug("tag detector process page {} error {}", (Object)page.getNodeIndex(), (Object)ExceptionTools.getMessage((Throwable)e));
        }
    }

    protected void processPageTree(PDPageTree pageTree, CSTagDetector detector) {
        for (PDPageNode node : pageTree.getKids()) {
            if (node.isPage()) {
                this.processPage((PDPage)node, detector);
                continue;
            }
            this.processPageTree((PDPageTree)node, detector);
        }
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setEndTag(char[] endTag) {
        this.endTag = (char[])endTag.clone();
    }

    public void setKeywordCaseSensitive(boolean keywordCaseSensitive) {
        this.keywordCaseSensitive = keywordCaseSensitive;
    }

    public void setKeywordSyntax(String keywordSyntax) {
        this.keywordSyntax = keywordSyntax;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public void setStartTag(char[] startTag) {
        this.startTag = (char[])startTag.clone();
    }
}

