/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.app.text.ILayoutProvider;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.element.CSCharacterElementParser;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Shape;

public class FullLayoutProvider
implements ILayoutProvider {
    public static FullLayoutProvider INSTANCE = new FullLayoutProvider();
    protected static final Attribute ATTR_CHARACTERS = new Attribute("characters");

    protected FullLayoutProvider() {
    }

    @Override
    public ILayoutContainer getLayout(PDPage page, Shape requestedRange) {
        ILayoutContainer container = (ILayoutContainer)page.getAttribute((Object)ATTR_CHARACTERS);
        if (container == null) {
            try {
                CSContent content = page.getContentStream();
                if (content == null) {
                    container = new LayoutContainer();
                } else {
                    CSCharacterElementParser parser = new CSCharacterElementParser();
                    CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, (ICSDevice)parser);
                    interpreter.process(content, page.getResources());
                    container = parser.getContainer();
                }
                page.setAttribute((Object)ATTR_CHARACTERS, (Object)container);
            }
            catch (CSException e) {
                e.printStackTrace();
                container = new LayoutContainer();
            }
        }
        return container;
    }
}

