/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.app.text.ILayoutProvider;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.element.CSCharacterElementParser;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalLayoutProvider
implements ILayoutProvider {
    public static IncrementalLayoutProvider INSTANCE = new IncrementalLayoutProvider();
    protected static final Attribute ATTR_CHARACTERRANGE = new Attribute("characterRange");
    protected static final Attribute ATTR_CHARACTERS = new Attribute("characters");
    private static final Logger Log = LoggerFactory.getLogger(IncrementalLayoutProvider.class);

    protected static Shape intersect(Shape ... shapes) {
        Area intersection = null;
        for (Shape shape : shapes) {
            if (intersection == null) {
                intersection = new Area(shape);
                continue;
            }
            intersection.intersect(new Area(shape));
        }
        if (intersection == null) {
            return new Rectangle2D.Float();
        }
        return intersection;
    }

    protected static Shape subtract(Shape baseShape, Shape ... shapes) {
        Area result = new Area(baseShape);
        for (Shape shape : shapes) {
            result.subtract(new Area(shape));
        }
        return result;
    }

    protected static Shape union(Shape ... shapes) {
        Area area = new Area();
        for (Shape shape : shapes) {
            area.add(new Area(shape));
        }
        return area;
    }

    protected IncrementalLayoutProvider() {
    }

    @Override
    public ILayoutContainer getLayout(PDPage page, Shape requestedRange) {
        ILayoutContainer container = (ILayoutContainer)page.getAttribute((Object)ATTR_CHARACTERS);
        Shape fullRange = null;
        Shape parserRange = null;
        if (container == null) {
            container = new LayoutContainer();
            fullRange = requestedRange;
            parserRange = requestedRange;
        } else {
            Shape containerRange = (Shape)page.getAttribute((Object)ATTR_CHARACTERRANGE);
            if (containerRange == null) {
                return container;
            }
            if (requestedRange != null) {
                parserRange = IncrementalLayoutProvider.subtract(requestedRange, containerRange);
                fullRange = IncrementalLayoutProvider.union(requestedRange, containerRange);
            }
        }
        try {
            CSContent content = page.getContentStream();
            if (content != null) {
                CSCharacterElementParser parser = new CSCharacterElementParser();
                parser.setContainer(container);
                parser.setBounds(parserRange);
                CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, (ICSDevice)parser);
                interpreter.process(content, page.getResources());
            }
            page.setAttribute((Object)ATTR_CHARACTERS, (Object)container);
            page.setAttribute((Object)ATTR_CHARACTERRANGE, (Object)fullRange);
        }
        catch (CSException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            container = new LayoutContainer();
        }
        return container;
    }
}

