/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.app.text.ILayoutProvider;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.element.CSCharacterElementParser;
import de.intarsys.pdf.pd.PDPage;
import java.awt.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetRangeLayoutProvider
implements ILayoutProvider {
    public static TargetRangeLayoutProvider INSTANCE = new TargetRangeLayoutProvider();
    private static final Logger Log = LoggerFactory.getLogger(TargetRangeLayoutProvider.class);

    protected TargetRangeLayoutProvider() {
    }

    @Override
    public ILayoutContainer getLayout(PDPage page, Shape requestedRange) {
        LayoutContainer container = new LayoutContainer();
        try {
            CSContent content = page.getContentStream();
            if (content != null) {
                CSCharacterElementParser parser = new CSCharacterElementParser();
                parser.setContainer((ILayoutContainer)container);
                parser.setBounds(requestedRange);
                CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, (ICSDevice)parser);
                interpreter.process(content, page.getResources());
            }
        }
        catch (CSException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            container = new LayoutContainer();
        }
        return container;
    }
}

