/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.content.element.CSCharacterElement;
import de.intarsys.pdf.content.element.CSLayoutElement;
import de.intarsys.pdf.content.element.CSTextLineElement;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TextExtractionTools {
    protected static AffineTransform createTransform(PDPage page) {
        int rotate = page.getNormalizedRotate();
        if (rotate == 0) {
            return null;
        }
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(-rotate));
        return transform;
    }

    protected static void sortLines(PDPage page, List<ILayoutComponent> lines) {
        final AffineTransform transform = TextExtractionTools.createTransform(page);
        Collections.sort(lines, new Comparator<ILayoutComponent>(){

            @Override
            public int compare(ILayoutComponent component1, ILayoutComponent component2) {
                double line2maxY;
                double line1maxY;
                CSTextLineElement line1 = (CSTextLineElement)component1;
                CSTextLineElement line2 = (CSTextLineElement)component2;
                Rectangle2D line1Rect = line1.getRect();
                Rectangle2D line2Rect = line2.getRect();
                if (transform != null) {
                    line1Rect = transform.createTransformedShape(line1Rect).getBounds2D();
                    line2Rect = transform.createTransformedShape(line2Rect).getBounds2D();
                }
                if ((line1maxY = line1Rect.getMaxY()) == (line2maxY = line2Rect.getMaxY())) {
                    return 0;
                }
                if (line1maxY > line2maxY) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static String writeElements(PDPage page, List<ILayoutComponent> lines) {
        StringBuilder sb = new StringBuilder();
        TextExtractionTools.sortLines(page, lines);
        TextExtractionTools.writeElements(page, lines, sb);
        return sb.toString();
    }

    protected static void writeElements(PDPage page, List<ILayoutComponent> lines, StringBuilder sb) {
        AffineTransform transform = TextExtractionTools.createTransform(page);
        CSLayoutElement recent = null;
        Iterator<ILayoutComponent> j = lines.iterator();
        while (j.hasNext()) {
            CSTextLineElement line = (CSTextLineElement)j.next();
            if (recent != null) {
                double distance;
                double ratio;
                Rectangle2D recentRect = recent.getRect();
                Rectangle2D lineRect = line.getRect();
                if (transform != null) {
                    recentRect = transform.createTransformedShape(recentRect).getBounds2D();
                    lineRect = transform.createTransformedShape(lineRect).getBounds2D();
                }
                if ((ratio = (distance = recentRect.getMinY() - lineRect.getMaxY()) / recentRect.getHeight()) > 0.5) {
                    sb.append(StringTools.LS);
                }
            }
            TextExtractionTools.writeLine(line, sb);
            if (j.hasNext()) {
                sb.append(StringTools.LS);
            }
            recent = line;
        }
    }

    protected static void writeLine(CSTextLineElement line, StringBuilder sb) {
        AffineTransform transform = line.getTransform();
        CSLayoutElement recent = null;
        for (CSCharacterElement character : line.getCharacters()) {
            char c;
            if (recent != null) {
                double distance;
                double ratio;
                Rectangle2D recentRect = recent.getRect();
                Rectangle2D charRect = character.getRect();
                if (transform != null) {
                    recentRect = transform.createTransformedShape(recentRect).getBounds2D();
                    charRect = transform.createTransformedShape(charRect).getBounds2D();
                }
                if ((ratio = (distance = charRect.getMinX() - recentRect.getMaxX()) / recentRect.getWidth()) > 0.3) {
                    sb.append(' ');
                }
            }
            if ((c = character.getCharacter()) == '\u0000') {
                c = ' ';
            }
            sb.append(c);
            recent = character;
        }
    }
}

