/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.pdf.app.text.TextExtractionTools;
import de.intarsys.pdf.app.text.TextSelector;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.attribute.Attribute;
import java.util.List;

public class TextExtractor {
    private TextSelector selector;
    protected static final Attribute ATTR_CHARACTERS = new Attribute("characters");

    public TextExtractor(PDDocument doc) {
        this.selector = new TextSelector(doc);
    }

    public PDDocument getDoc() {
        return this.selector.getDoc();
    }

    protected TextSelector getSelector() {
        return this.selector;
    }

    public String getTextWithin(int pageIndex, double x1, double y1, double x2, double y2) {
        return this.getTextWithin(pageIndex, x1, y1, x2, y2, false);
    }

    public String getTextWithin(int pageIndex, double x1, double y1, double x2, double y2, boolean floating) {
        PDPage page = this.getDoc().getPageTree().getPageAt(pageIndex);
        if (x1 == x2) {
            x2 += 1.0;
        }
        if (y1 == y2) {
            y2 += 1.0;
        }
        List<ILayoutComponent> selected = null;
        selected = floating ? this.getSelector().getElementsFloating(page, x1, y1, x2, y2) : this.getSelector().getElementsWithin(page, x1, y1, x2, y2);
        return TextExtractionTools.writeElements(page, selected);
    }
}

