/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.text;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutContainer;
import de.intarsys.layout.LayoutContainer;
import de.intarsys.pdf.app.text.ILayoutProvider;
import de.intarsys.pdf.app.text.TargetRangeLayoutProvider;
import de.intarsys.pdf.content.element.CSCharacterElement;
import de.intarsys.pdf.content.element.CSTextLineElement;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextSelector {
    private PDDocument doc;
    private ILayoutProvider layoutProvider;

    protected static Shape intersect(Shape a, Shape b) {
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.intersect(areaB);
        return areaA;
    }

    protected static Shape subtract(Shape a, Shape b) {
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.subtract(areaB);
        return areaA;
    }

    protected static Shape union(Shape a, Shape b) {
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.add(areaB);
        return areaA;
    }

    public TextSelector(PDDocument doc) {
        this.doc = doc;
    }

    protected void addCharacterElement(PDPage page, CSCharacterElement element, LayoutContainer lineBasedLayout) {
        for (ILayoutComponent component : lineBasedLayout.children()) {
            CSTextLineElement lineElement = (CSTextLineElement)component;
            if (!lineElement.mayIncludeCharacter(element)) continue;
            lineElement.addCharacter(element);
            return;
        }
        CSTextLineElement line = new CSTextLineElement(page.getNormalizedRotate());
        line.addCharacter(element);
        lineBasedLayout.add((ILayoutComponent)line);
    }

    protected List<CSCharacterElement> getCharactersWithin(PDPage page, Shape shape) {
        ArrayList<CSCharacterElement> characters = new ArrayList<CSCharacterElement>();
        ILayoutContainer layout = this.getLayout(page, shape);
        for (ILayoutComponent child : layout.children()) {
            CSCharacterElement element = (CSCharacterElement)child;
            if (!shape.intersects(element.getRect())) continue;
            characters.add(element);
        }
        return characters;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public List<ILayoutComponent> getElementsFloating(PDPage page, double x1, double y1, double x2, double y2) {
        int lastIndex;
        CSTextLineElement last;
        CSTextLineElement first;
        double ux = 0.0;
        double uy = 0.0;
        double lx = 0.0;
        double ly = 0.0;
        double sx1 = 0.0;
        double sy1 = 0.0;
        double sx2 = 0.0;
        double sy2 = 0.0;
        double lmx = 0.0;
        double lmy = 0.0;
        double rmx = 0.0;
        double rmy = 0.0;
        Rectangle2D pageRect = page.getMediaBox().toNormalizedRectangle();
        switch (page.getNormalizedRotate()) {
            case 0: {
                if (y1 > y2) {
                    ux = x1;
                    uy = y1;
                    lx = x2;
                    ly = y2;
                } else {
                    ux = x2;
                    uy = y2;
                    lx = x1;
                    ly = y1;
                }
                if (x1 > x2) {
                    lmx = x2;
                    lmy = y2;
                    rmx = x1;
                    rmy = y1;
                } else {
                    lmx = x1;
                    lmy = y1;
                    rmx = x2;
                    rmy = y2;
                }
                sx1 = pageRect.getMinX();
                sy1 = uy;
                sx2 = pageRect.getMaxX();
                sy2 = ly;
                break;
            }
            case 90: {
                if (x1 < x2) {
                    ux = x1;
                    uy = y1;
                    lx = x2;
                    ly = y2;
                } else {
                    ux = x2;
                    uy = y2;
                    lx = x1;
                    ly = y1;
                }
                if (y1 > y2) {
                    lmx = x2;
                    lmy = y2;
                    rmx = x1;
                    rmy = y1;
                } else {
                    lmx = x1;
                    lmy = y1;
                    rmx = x2;
                    rmy = y2;
                }
                sx1 = ux;
                sy1 = pageRect.getMinY();
                sx2 = lx;
                sy2 = pageRect.getMaxY();
                break;
            }
            case 180: {
                if (y1 < y2) {
                    ux = x1;
                    uy = y1;
                    lx = x2;
                    ly = y2;
                } else {
                    ux = x2;
                    uy = y2;
                    lx = x1;
                    ly = y1;
                }
                if (x1 < x2) {
                    lmx = x2;
                    lmy = y2;
                    rmx = x1;
                    rmy = y1;
                } else {
                    lmx = x1;
                    lmy = y1;
                    rmx = x2;
                    rmy = y2;
                }
                sx1 = pageRect.getMinX();
                sy1 = uy;
                sx2 = pageRect.getMaxX();
                sy2 = ly;
                break;
            }
            case 270: {
                if (x1 > x2) {
                    ux = x1;
                    uy = y1;
                    lx = x2;
                    ly = y2;
                } else {
                    ux = x2;
                    uy = y2;
                    lx = x1;
                    ly = y1;
                }
                if (y1 < y2) {
                    lmx = x2;
                    lmy = y2;
                    rmx = x1;
                    rmy = y1;
                } else {
                    lmx = x1;
                    lmy = y1;
                    rmx = x2;
                    rmy = y2;
                }
                sx1 = ux;
                sy1 = pageRect.getMinY();
                sx2 = lx;
                sy2 = pageRect.getMaxY();
            }
        }
        List<ILayoutComponent> lines = this.getLines(page, sx1, sy1, sx2, sy2);
        if (lines.size() == 1) {
            ux = lmx;
            uy = lmy;
            lx = rmx;
            ly = rmy;
        }
        if (lines.size() > 0 && (first = (CSTextLineElement)lines.get(0)).contains(ux, uy)) {
            CSTextLineElement[] split = first.splitAt(ux, uy);
            if (split[1] == null) {
                lines.remove(0);
            } else {
                lines.set(0, split[1]);
            }
        }
        if (lines.size() > 0 && (last = (CSTextLineElement)lines.get(lastIndex = lines.size() - 1)).contains(lx, ly)) {
            CSTextLineElement[] split = last.splitAt(lx, ly);
            if (split[0] == null) {
                lines.remove(lastIndex);
            } else {
                lines.set(lastIndex, split[0]);
            }
        }
        return lines;
    }

    public List<ILayoutComponent> getElementsWithin(PDPage page, double x1, double y1, double x2, double y2) {
        return this.getLines(page, x1, y1, x2, y2);
    }

    protected ILayoutContainer getLayout(PDPage page, Shape requestedRange) {
        return this.getLayoutProvider().getLayout(page, requestedRange);
    }

    public ILayoutProvider getLayoutProvider() {
        if (this.layoutProvider == null) {
            this.layoutProvider = TargetRangeLayoutProvider.INSTANCE;
        }
        return this.layoutProvider;
    }

    protected ILayoutContainer getLineBasedLayout(PDPage page, Shape shape) {
        List<CSCharacterElement> characters = this.getCharactersWithin(page, shape);
        LayoutContainer lineBasedLayout = new LayoutContainer();
        for (CSCharacterElement characterElement : characters) {
            this.addCharacterElement(page, characterElement, lineBasedLayout);
        }
        return lineBasedLayout;
    }

    protected List<ILayoutComponent> getLines(PDPage page, double uy, double ly) {
        Rectangle2D pageRect = page.getMediaBox().toNormalizedRectangle();
        return this.getLines(page, pageRect.getMinX(), uy, pageRect.getMaxX(), ly);
    }

    protected List<ILayoutComponent> getLines(PDPage page, double x1, double y1, double x2, double y2) {
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        Rectangle2D.Double selectionRect = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        return new ArrayList<ILayoutComponent>(Arrays.asList(this.getLineBasedLayout(page, selectionRect).children()));
    }

    public void setLayoutProvider(ILayoutProvider layoutProvider) {
        this.layoutProvider = layoutProvider;
    }
}

