/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.treemodel;

import de.intarsys.pdf.app.treemodel.COSContainerSlotTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSObject;

public class COSArraySlotTreeNode
extends COSContainerSlotTreeNode {
    private final int index;

    public COSArraySlotTreeNode(COSContainerSlotTreeNode parent, COSArray container, int index) {
        super(parent, container);
        this.index = index;
    }

    @Override
    protected COSDocumentElement basicGet() {
        if (this.getArray() == null) {
            return null;
        }
        return this.getArray().basicGet(this.getIndex());
    }

    @Override
    public void delete() {
        this.getArray().remove(this.get().dereference());
    }

    public COSArray getArray() {
        return (COSArray)this.getObject();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPrefix() {
        return "[" + String.valueOf(this.getIndex()) + "]";
    }

    public void moveDown() {
        COSDocumentElement element = this.get();
        COSArray array = this.getArray();
        int index = this.getIndex();
        array.remove(element.dereference());
        int newIndex = Math.min(index + 1, array.size());
        array.add(newIndex, element.dereference());
    }

    public void moveUp() {
        COSDocumentElement element = this.get();
        COSArray array = this.getArray();
        int index = this.getIndex();
        array.remove(element.dereference());
        int newIndex = Math.max(index - 1, 0);
        array.add(newIndex, element.dereference());
    }

    @Override
    public void set(COSObject value) {
        this.getArray().set(this.getIndex(), value);
    }
}

