/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.treemodel;

import de.intarsys.pdf.app.treemodel.COSBrowserTreeNode;
import de.intarsys.pdf.app.treemodel.COSContainerSlotTreeNode;
import de.intarsys.pdf.app.treemodel.COSDocumentElementTreeNode;
import de.intarsys.pdf.app.treemodel.COSObjectTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSTrue;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public abstract class COSContainerTreeNode
extends COSObjectTreeNode
implements ICOSObjectListener,
INotificationSupport {
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private List children;
    private boolean listenerMounted = false;

    public COSContainerTreeNode(COSBrowserTreeNode wrapper, COSDocumentElement element) {
        super(wrapper, element);
    }

    public void addChangeListener(INotificationListener listener) {
        if (!this.listenerMounted) {
            this.listenerMounted = true;
            ((COSCompositeObject)this.getObject()).addObjectListener((ICOSObjectListener)this);
        }
        this.dispatcher.addNotificationListener(AttributeChangedEvent.ID, listener);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (!this.listenerMounted) {
            this.listenerMounted = true;
            ((COSCompositeObject)this.getObject()).addObjectListener((ICOSObjectListener)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected List basicGetChildren() {
        return this.children;
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    protected void clearChildren() {
        this.children = null;
    }

    protected abstract List createChildren();

    @Override
    public void dispose() {
        this.dispatcher.clear();
        ((COSCompositeObject)this.getObject()).removeObjectListener((ICOSObjectListener)this);
        super.dispose();
    }

    @Override
    public void disposeChildren() {
        if (this.basicGetChildren() != null) {
            for (COSContainerSlotTreeNode slot : this.basicGetChildren()) {
                slot.dispose();
            }
        }
        this.clearChildren();
        super.disposeChildren();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    protected abstract void insert(COSObject var1);

    public void insertNewArray() {
        COSArray object = COSArray.create();
        this.insert((COSObject)object);
    }

    public void insertNewBoolean() {
        COSTrue object = COSTrue.create();
        this.insert((COSObject)object);
    }

    public void insertNewDictionary() {
        COSDictionary object = COSDictionary.create();
        this.insert((COSObject)object);
    }

    public void insertNewName() {
        COSName object = COSName.create((String)"new name");
        this.insert((COSObject)object);
    }

    public void insertNewNull() {
        COSNull object = COSNull.create();
        this.insert((COSObject)object);
    }

    public void insertNewNumber() {
        COSFixed object = COSFixed.create((float)0.0f);
        this.insert((COSObject)object);
    }

    public void insertNewStream() {
        COSStream object = COSStream.create(null);
        this.insert((COSObject)object);
    }

    public void insertNewString() {
        COSString object = COSString.create((String)"new string");
        this.insert((COSObject)object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void paste() {
        COSBrowserTreeNode clip = COSContainerTreeNode.getClip();
        if (clip == null) {
            return;
        }
        COSObject cosClip = clip.getCosObject();
        COSObject cosCopy = null;
        cosCopy = this.getCosObject().getDoc() != cosClip.getDoc() ? cosClip.copyDeep() : cosClip.copyShallow();
        this.paste(cosCopy);
    }

    protected abstract void paste(COSObject var1);

    @Override
    public void pasteLink() {
        COSBrowserTreeNode clip = COSContainerTreeNode.getClip();
        if (clip == null) {
            return;
        }
        COSObject cosClip = clip.getCosObject();
        COSObject cosCopy = null;
        if (cosClip.getDoc() != null && this.getCosObject().getDoc() != cosClip.getDoc()) {
            cosCopy = cosClip.copyDeep();
        } else {
            cosClip.beIndirect();
            cosCopy = cosClip.copyOptional();
        }
        this.paste(cosCopy);
    }

    public void removeChangeListener(INotificationListener listener) {
        this.dispatcher.removeNotificationListener(AttributeChangedEvent.ID, listener);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void triggerChanged(COSContainerTreeNode objectWrapper, Object slot, COSDocumentElementTreeNode oldValue, COSDocumentElementTreeNode newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)objectWrapper, slot, (Object)oldValue, (Object)newValue);
        this.dispatcher.triggerEvent((Event)event);
    }
}

