/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.treemodel;

import de.intarsys.pdf.app.treemodel.COSContainerSlotTreeNode;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;

public class COSDictionarySlotTreeNode
extends COSContainerSlotTreeNode {
    private final COSName key;

    public COSDictionarySlotTreeNode(COSContainerSlotTreeNode parent, COSDictionary container, COSName key) {
        super(parent, container);
        this.key = key;
    }

    @Override
    protected COSDocumentElement basicGet() {
        if (this.getDictionary() == null) {
            return null;
        }
        return this.getDictionary().basicGet(this.key);
    }

    @Override
    public void delete() {
        this.getDictionary().remove(this.key);
    }

    public COSDictionary getDictionary() {
        return (COSDictionary)this.getObject();
    }

    public COSName getKey() {
        return this.key;
    }

    public String getKeyString() {
        return this.key.stringValue();
    }

    @Override
    public String getPrefix() {
        return this.key.toString();
    }

    public void rename(String newName) {
        COSDocumentElement element = this.get();
        COSDictionary dict = this.getDictionary();
        dict.remove(this.key);
        dict.put(COSName.create((String)newName), element.dereference());
    }

    @Override
    public void set(COSObject value) {
        this.getDictionary().put(this.key, value);
    }
}

