/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.treemodel;

import de.intarsys.pdf.app.treemodel.COSBrowserTreeNode;
import de.intarsys.pdf.app.treemodel.COSContainerSlotTreeNode;
import de.intarsys.pdf.app.treemodel.COSContainerTreeNode;
import de.intarsys.pdf.app.treemodel.COSDictionarySlotTreeNode;
import de.intarsys.pdf.app.treemodel.COSDocumentElementTreeNode;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;

public class COSDictionaryTreeNode
extends COSContainerTreeNode {
    private Map mappedChildren;

    protected COSDictionaryTreeNode(COSBrowserTreeNode wrapper, COSDocumentElement element) {
        super(wrapper, element);
    }

    public void changed(COSObject object, Object slot, Object oldValue, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        if (slot == COSObject.SLOT_CONTAINER) {
            return;
        }
        COSDictionarySlotTreeNode slotNode = null;
        COSDocumentElementTreeNode oldNode = null;
        COSDocumentElementTreeNode newNode = null;
        if (slot == null || oldValue instanceof COSObject && ((COSObject)oldValue).isNull() || newValue instanceof COSObject && ((COSObject)newValue).isNull()) {
            this.disposeChildren();
        } else if (this.mappedChildren != null && (slotNode = (COSDictionarySlotTreeNode)this.mappedChildren.get(slot)) != null) {
            oldNode = slotNode.getWrapped();
            slotNode.refresh();
            newNode = slotNode.getWrapped();
        }
        this.triggerChanged(this, slotNode, oldNode, newNode);
    }

    @Override
    protected void clearChildren() {
        super.clearChildren();
        this.mappedChildren = null;
    }

    @Override
    protected List createChildren() {
        ArrayList<COSContainerSlotTreeNode> result = new ArrayList<COSContainerSlotTreeNode>();
        this.mappedChildren = new HashMap();
        for (COSName key : this.getDictionary().keySet()) {
            COSContainerSlotTreeNode node = COSContainerSlotTreeNode.createTreeNode(this.getWrapperRoot(), this.getDictionary(), key);
            result.add(node);
            this.mappedChildren.put(key, node);
        }
        return result;
    }

    protected COSName createName() {
        int counter = 0;
        String name = "new" + counter;
        COSName result = COSName.create((String)name);
        while (this.getDictionary().containsKey(result)) {
            name = "new" + ++counter;
            result = COSName.create((String)name);
        }
        return result;
    }

    protected TreeNode getChildAt(COSName key) {
        return (TreeNode)this.mappedChildren.get(key);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getChildren().get(childIndex);
    }

    protected COSDictionary getDictionary() {
        return (COSDictionary)this.getObject();
    }

    protected String getDisplayType() {
        return "Dictionary";
    }

    public String getIconName() {
        return "dictionary";
    }

    public String getLabel() {
        COSName type = this.getDictionary().get(PDObject.DK_Type).asName();
        if (type != null) {
            return new String(type.byteValue());
        }
        return this.getDisplayType();
    }

    @Override
    protected void insert(COSObject object) {
        this.getDictionary().put(this.createName(), object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected void paste(COSObject cosCopy) {
        COSName cosName = null;
        cosName = COSDictionaryTreeNode.getClip() instanceof COSDictionarySlotTreeNode ? ((COSDictionarySlotTreeNode)COSDictionaryTreeNode.getClip()).getKey() : this.createName();
        this.getDictionary().put(cosName, cosCopy);
    }
}

