/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.xmp;

import de.intarsys.pdf.app.xmp.PDFAIdentification;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDDocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMPTools {
    private static final String PDFA_ID_NAMESPACE_URI = "http://www.aiim.org/pdfa/ns/id/";
    private static final String PART_LN = "part";
    private static final String AMENDMENT_LN = "amd";
    private static final String CORRIGENDUM_LN = "corr";
    private static final String CONFORMANCE_LN = "conformance";
    private static final String RDF_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String DESCRIPTION_LN = "Description";
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newDefaultFactory();

    public static boolean claimsPDFACompliance(PDDocument document) {
        PDFAIdentification id = XMPTools.getPDFAIdentification(document);
        return id != null && id.getPart() != null;
    }

    public static PDFAIdentification getPDFAIdentification(PDDocument document) {
        byte[] metadata = XMPTools.getMetadata(document);
        if (metadata == null) {
            return null;
        }
        try {
            return XMPTools.parsePDFAIdentification(new ByteArrayInputStream(metadata));
        }
        catch (FactoryConfigurationError | XMLStreamException exception) {
            return null;
        }
    }

    private static byte[] getMetadata(PDDocument document) {
        COSCatalog catalog = document.getCatalog();
        if (catalog == null) {
            return null;
        }
        COSStream metadataStream = catalog.cosGetField(COSCatalog.DK_Metadata).asStream();
        return metadataStream == null ? null : metadataStream.getDecodedBytes();
    }

    private static PDFAIdentification parsePDFAIdentification(InputStream inputStream) throws XMLStreamException, FactoryConfigurationError {
        String part = null;
        String amendment = null;
        String corrigendum = null;
        String conformance = null;
        XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(inputStream);
        while (reader.hasNext()) {
            if (reader.next() != 1) continue;
            String elementNamespace = reader.getNamespaceURI();
            if (RDF_NAMESPACE_URI.equals(elementNamespace)) {
                if (!DESCRIPTION_LN.equals(reader.getLocalName())) continue;
                int attributeCount = reader.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    String attributeNamespace = reader.getAttributeNamespace(i);
                    if (!PDFA_ID_NAMESPACE_URI.equals(attributeNamespace)) continue;
                    String attributeLocalName = reader.getAttributeLocalName(i);
                    if (PART_LN.equals(attributeLocalName)) {
                        part = reader.getAttributeValue(i);
                        continue;
                    }
                    if (AMENDMENT_LN.equals(attributeLocalName)) {
                        amendment = reader.getAttributeValue(i);
                        continue;
                    }
                    if (CORRIGENDUM_LN.equals(attributeLocalName)) {
                        corrigendum = reader.getAttributeValue(i);
                        continue;
                    }
                    if (!CONFORMANCE_LN.equals(attributeLocalName)) continue;
                    conformance = reader.getAttributeValue(i);
                }
                continue;
            }
            if (!PDFA_ID_NAMESPACE_URI.equals(elementNamespace)) continue;
            String elementLocalName = reader.getLocalName();
            if (PART_LN.equals(elementLocalName)) {
                part = reader.getElementText();
                continue;
            }
            if (AMENDMENT_LN.equals(elementLocalName)) {
                amendment = reader.getElementText();
                continue;
            }
            if (CORRIGENDUM_LN.equals(elementLocalName)) {
                corrigendum = reader.getElementText();
                continue;
            }
            if (!CONFORMANCE_LN.equals(elementLocalName)) continue;
            conformance = reader.getElementText();
        }
        if (part == null && amendment == null && corrigendum == null && conformance == null) {
            return null;
        }
        return new PDFAIdentification(part, amendment, corrigendum, conformance);
    }

    static {
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }
}

