/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.element;

import de.intarsys.layout.ILayoutComponent;
import de.intarsys.layout.ILayoutVisitor;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;

public abstract class CSLayoutElement
implements ILayoutComponent {
    private Rectangle2D rect = new Rectangle2D.Float();

    public Object accept(ILayoutVisitor visitor) {
        return visitor.visitFromLayoutComponent((ILayoutComponent)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CSLayoutElement)) {
            return false;
        }
        CSLayoutElement partner = (CSLayoutElement)obj;
        if (this.getRect() == null) {
            return partner.getRect() == null;
        }
        return this.getRect().equals(partner.getRect());
    }

    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Float(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public float getHeight() {
        return (float)this.getRect().getHeight();
    }

    public float getMaxX() {
        return (float)this.getRect().getMaxX();
    }

    public float getMaxY() {
        return (float)this.getRect().getMaxY();
    }

    public float getMinX() {
        return (float)this.getRect().getMinX();
    }

    public float getMinY() {
        return (float)this.getRect().getMinY();
    }

    public Rectangle2D getRect() {
        return this.rect;
    }

    public float getWidth() {
        return (float)this.getRect().getWidth();
    }

    public int hashCode() {
        return Objects.hash(this.rect);
    }

    public boolean isForced() {
        return false;
    }

    public void move(float dx, float dy) {
        this.moveTo(this.getMinX() + dx, this.getMinY() + dy);
    }

    public void moveTo(float x, float y) {
        this.getRect().setRect(x, y, this.rect.getWidth(), this.rect.getHeight());
    }

    public void resetLayout() {
    }

    public void setHeight(float height) {
        this.getRect().setRect(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), height);
    }

    public void setRect(Rectangle2D rect) {
        this.rect = rect;
    }

    public void setWidth(float width) {
        this.getRect().setRect(this.rect.getX(), this.rect.getY(), width, this.getRect().getHeight());
    }

    public List splitHorizontal(float max) {
        return null;
    }

    public List splitVertical(float max, boolean reverse) {
        return null;
    }

    public void trim() {
    }
}

