/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.element;

import de.intarsys.pdf.content.element.CSCharacterElement;
import de.intarsys.pdf.content.element.CSLayoutElement;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CSTextLineElement
extends CSLayoutElement {
    private List characters = new ArrayList();
    private int rotation = 0;
    private AffineTransform transform;

    public CSTextLineElement() {
    }

    public CSTextLineElement(int rotation) {
        this.rotation = PDFGeometryTools.normalizeRotate((int)rotation);
    }

    public void addCharacter(CSCharacterElement character) {
        CSCharacterElement element;
        double elementX;
        int index = 0;
        double charX = this.rotate(character.getRect()).getX();
        Iterator i = this.characters.iterator();
        while (i.hasNext() && !(charX < (elementX = this.rotate((element = (CSCharacterElement)i.next()).getRect()).getX()))) {
            ++index;
        }
        this.characters.add(index, character);
        if (this.characters.size() == 1) {
            this.setRect((Rectangle2D)character.getRect().clone());
        } else {
            Rectangle2D.union(this.getRect(), character.getRect(), this.getRect());
        }
    }

    public boolean contains(double x, double y) {
        AffineTransform transform = this.getTransform();
        if (transform != null) {
            double[] pts = new double[]{x, y};
            this.getTransform().transform(pts, 0, pts, 0, 1);
            x = pts[0];
            y = pts[1];
        }
        Rectangle2D myRect = this.rotate(this.getRect());
        return myRect.contains(x, y);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSTextLineElement)) {
            return false;
        }
        CSTextLineElement partner = (CSTextLineElement)obj;
        if (!this.getCharacters().equals(partner.getCharacters())) {
            return false;
        }
        return this.getRotation() == partner.getRotation();
    }

    public List getCharacters() {
        return this.characters;
    }

    public int getRotation() {
        return this.rotation;
    }

    public AffineTransform getTransform() {
        if (this.transform == null && this.rotation != 0) {
            this.transform = new AffineTransform();
            this.transform.rotate(Math.toRadians(-this.rotation));
        }
        return this.transform;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.characters, this.rotation);
    }

    public boolean mayIncludeCharacter(CSCharacterElement character) {
        Rectangle2D lineRect = this.rotate(this.getRect());
        Rectangle2D charRect = this.rotate(character.getRect());
        if (charRect.getMinY() > lineRect.getMaxY()) {
            return false;
        }
        if (charRect.getMaxY() < lineRect.getMinY()) {
            return false;
        }
        if (charRect.getMaxY() > lineRect.getMaxY()) {
            double common = lineRect.getMaxY() - charRect.getMinY();
            return common > charRect.getHeight() * 0.5;
        }
        if (charRect.getMinY() < lineRect.getMinY()) {
            double common = charRect.getMaxY() - lineRect.getMinY();
            return common > charRect.getHeight() * 0.5;
        }
        return true;
    }

    protected Rectangle2D rotate(Rectangle2D rect) {
        AffineTransform transform = this.getTransform();
        if (transform == null) {
            return rect;
        }
        return transform.createTransformedShape(rect).getBounds2D();
    }

    public CSTextLineElement[] splitAt(double x, double y) {
        AffineTransform transform = this.getTransform();
        if (transform != null) {
            double[] pts = new double[]{x, y};
            this.getTransform().transform(pts, 0, pts, 0, 1);
            x = pts[0];
            y = pts[1];
        }
        CSTextLineElement before = new CSTextLineElement(this.getRotation());
        CSTextLineElement after = new CSTextLineElement(this.getRotation());
        for (CSCharacterElement character : this.characters) {
            if (this.rotate(character.getRect()).getCenterX() < x) {
                before.addCharacter(character);
                continue;
            }
            after.addCharacter(character);
        }
        CSTextLineElement[] result = new CSTextLineElement[2];
        if (!before.getCharacters().isEmpty()) {
            result[0] = before;
        }
        if (!after.getCharacters().isEmpty()) {
            result[1] = after;
        }
        return result;
    }
}

