/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Image;
import de.intarsys.pdf.design.shape.None;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.sample.Samples;
import de.intarsys.tools.enumeration.common.PointAlignment;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.PointSpec;
import de.intarsys.tools.locator.ExpandingLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;

public class Canvas
extends Shape {
    public static final String TYPE = "canvas";

    public static Canvas create(IArgs args) {
        Canvas shape = new Canvas();
        shape.init(args);
        return shape;
    }

    @Override
    public void draw(IDrawContext drawContext, CSCreator creator, Dimension2D containerSize) {
        this.getContent().draw(drawContext, creator, containerSize);
    }

    @Override
    public RectAlignment getAlignment() {
        return this.getContent().getAlignment();
    }

    @Override
    public PointAlignment getAnchor() {
        return this.getContent().getAnchor();
    }

    @Override
    public Shape getContent() {
        return (Shape)super.getContent();
    }

    @Override
    protected RectAlignment getDefaultAlignment() {
        return this.getContent().getDefaultAlignment();
    }

    @Override
    protected PointAlignment getDefaultAnchor() {
        return this.getContent().getDefaultAnchor();
    }

    @Override
    protected boolean getDefaultMoveContentToOrigin() {
        return this.getContent().getDefaultMoveContentToOrigin();
    }

    @Override
    protected String getDefaultNonStrokeColor() {
        return this.getContent().getDefaultNonStrokeColor();
    }

    @Override
    protected Point2D getDefaultPosition(IDrawContext drawContext, Dimension2D containerSize) {
        return this.getContent().getDefaultPosition(drawContext, containerSize);
    }

    @Override
    protected String getDefaultPositionSpec() {
        return this.getContent().getDefaultPositionSpec();
    }

    @Override
    protected Dimension2D getDefaultSize(IDrawContext drawContext, Dimension2D containerSize) {
        return this.getContent().getDefaultSize(drawContext, containerSize);
    }

    @Override
    protected String getDefaultSizeSpec() {
        return this.getContent().getDefaultSizeSpec();
    }

    @Override
    protected String getDefaultStrokeColor() {
        return this.getContent().getDefaultStrokeColor();
    }

    @Override
    protected float getDefaultStrokeWidth() {
        return this.getContent().getDefaultStrokeWidth();
    }

    protected ILocator getLocator(IArgs args) {
        try {
            ExpandingLocatorFactory factory = new ExpandingLocatorFactory(LocatorFactory.get(), TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
            return LocatorTools.createLocator((Object)args, (ILocatorFactory)factory, null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("malformed canvas content, locator expected", e);
        }
    }

    @Override
    public float[] getNonStrokeColor() {
        return this.getContent().getNonStrokeColor();
    }

    @Override
    public Point2D getPosition() {
        return this.getContent().getPosition();
    }

    @Override
    public PointSpec getPositionSpec() {
        return this.getContent().getPositionSpec();
    }

    @Override
    public Dimension2D getSize() {
        return this.getContent().getSize();
    }

    @Override
    public PointSpec getSizeSpec() {
        return this.getContent().getSizeSpec();
    }

    @Override
    public int getStrokeCap() {
        return this.getContent().getStrokeCap();
    }

    @Override
    public float[] getStrokeColor() {
        return this.getContent().getStrokeColor();
    }

    @Override
    public int getStrokeJoin() {
        return this.getContent().getStrokeJoin();
    }

    @Override
    public float getStrokeWidth() {
        return this.getContent().getStrokeWidth();
    }

    @Override
    protected void init(IArgs args) {
        Shape contentShape;
        IArgs argContent = ArgTools.getArgs((IArgs)args, (String)"content", null);
        if (argContent == null || argContent.size() == 0) {
            contentShape = None.create(argContent);
        } else {
            String argType = ArgTools.getString((IArgs)argContent, (String)"type", null);
            if (StringTools.isEmpty((String)argType) || "image".equals(argType)) {
                Image image = Image.create(argContent);
                image.setImage(this.getLocator(argContent));
                contentShape = image;
            } else if ("samples".equals(argType)) {
                ArgTools.putPathIfAbsent((IArgs)argContent, (String)"format", (Object)"jsSignature");
                contentShape = Samples.create(argContent);
            } else {
                throw new IllegalArgumentException("unsupported canvas type " + argType);
            }
        }
        this.setContent(contentShape);
        super.init(args);
    }

    @Override
    public boolean isMoveContentToOrigin() {
        return this.getContent().isMoveContentToOrigin();
    }

    @Override
    public void layout(IDrawContext drawContext, Dimension2D containerSize) {
        this.getContent().layout(drawContext, containerSize);
    }

    @Override
    public void setAlignment(RectAlignment alignment) {
        this.getContent().setAlignment(alignment);
    }

    @Override
    public void setAnchor(PointAlignment anchor) {
        this.getContent().setAnchor(anchor);
    }

    @Override
    public void setMoveContentToOrigin(boolean includeOrigin) {
        this.getContent().setMoveContentToOrigin(includeOrigin);
    }

    @Override
    public void setNonStrokeColor(float[] nonStrokeColor) {
        this.getContent().setNonStrokeColor(nonStrokeColor);
    }

    @Override
    public void setPositionSpec(PointSpec position) {
        this.getContent().setPositionSpec(position);
    }

    @Override
    public void setPositionSpec(String definition) {
        this.getContent().setPositionSpec(definition);
    }

    @Override
    public void setSizeSpec(PointSpec size) {
        this.getContent().setSizeSpec(size);
    }

    @Override
    public void setSizeSpec(String definition) {
        this.getContent().setSizeSpec(definition);
    }

    @Override
    public void setStrokeCap(int strokeCap) {
        this.getContent().setStrokeCap(strokeCap);
    }

    @Override
    public void setStrokeColor(float[] strokeColor) {
        this.getContent().setStrokeColor(strokeColor);
    }

    @Override
    public void setStrokeJoin(int strokeJoin) {
        this.getContent().setStrokeJoin(strokeJoin);
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.getContent().setStrokeWidth(strokeWidth);
    }
}

