/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.design.shape.CommonShapeFactory;
import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.Text;
import de.intarsys.pdf.design.shape.sample.Path;
import de.intarsys.pdf.design.shape.sample.Sample;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.form.model.FieldTypes;
import de.intarsys.tools.form.model.FieldValue;
import de.intarsys.tools.form.model.TextBasedField;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.PointSpec;
import de.intarsys.tools.lang.BooleanTools;

public class CheckboxShapeFactory
extends CommonShapeFactory {
    @Override
    protected Shape basicCreateShape(FieldValue fieldValue) {
        TextBasedField field = (TextBasedField)fieldValue.getField();
        float fontSize = field.getFontSize();
        float cbSize = fontSize < 0.0f ? 10.0f : fontSize;
        float cbWidth = 1.5f * cbSize;
        float cbMargin = cbWidth / 5.0f;
        Path path = Path.create((IArgs)Args.create());
        path.setStrokeWidth(3.0f);
        path.setStrokeCap(1);
        path.setStrokeJoin(1);
        path.setPositionSpec(PointSpec.absolute((double)0.0, (double)0.0));
        path.setAlignment(RectAlignment.parse((String)"center;fill"));
        try {
            path.addSample(new Sample(0.0, 0.0, 0.0));
            path.addSample(new Sample(cbWidth, cbWidth, 0.0));
            path.addSample(new Sample(cbMargin, cbMargin, 1.0));
            path.addSample(new Sample(cbWidth - cbMargin, cbMargin, 1.0));
            path.addSample(new Sample(cbWidth - cbMargin, cbWidth - cbMargin, 1.0));
            path.addSample(new Sample(cbMargin, cbWidth - cbMargin, 1.0));
            path.addSample(new Sample(cbMargin, cbMargin, 1.0));
            if (BooleanTools.toBoolean((Object)fieldValue.getValue(), (boolean)false)) {
                path.addSample(new Sample(0.0, 0.0, 0.0));
                path.addSample(new Sample((double)cbWidth * 0.25, (double)cbWidth * 0.4, 1.0));
                path.addSample(new Sample((double)cbWidth * 0.4, (double)cbWidth * 0.2, 1.0));
                path.addSample(new Sample((double)cbWidth * 0.75, (double)cbWidth * 0.8, 1.0));
            }
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("field " + field.getId() + " illegal boolean value", e);
        }
        Text text = Text.create((IArgs)Args.create());
        text.setText(field.getLabel());
        text.setFontSize(fontSize);
        text.setPositionSpec(PointSpec.absolute((double)cbWidth, (double)0.0));
        text.setAlignment(RectAlignment.parse((String)"center;fill"));
        Group shape = Group.create((IArgs)Args.create());
        shape.addShape(path);
        shape.addShape(text);
        return shape;
    }

    @Override
    protected void basicCustomizeShape(Shape shape, FieldValue fieldValue) {
        super.basicCustomizeShape(shape, fieldValue);
    }

    @Override
    protected FieldType getFieldType() {
        return FieldTypes.CHECKBOX;
    }
}

