/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.design.shape.IShapeFactory;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.form.model.FieldValue;
import de.intarsys.tools.geometry.PointSpec;

public abstract class CommonShapeFactory
implements IShapeFactory {
    protected boolean acceptType(FieldValue value) {
        return value.getField().getType() == this.getFieldType();
    }

    protected abstract Shape basicCreateShape(FieldValue var1);

    protected void basicCustomizeShape(Shape shape, FieldValue fieldValue) {
        CommonField field = fieldValue.getField();
        shape.setPositionSpec(PointSpec.absolute((double)0.0, (double)0.0));
        shape.setSizeSpec(PointSpec.percent((double)100.0, (double)100.0));
        RectAlignment align = RectAlignment.create();
        EnumResize hResize = field.getHResize();
        EnumResize vResize = field.getVResize();
        hResize = hResize == null ? this.createResizeDefault(fieldValue) : hResize;
        vResize = vResize == null ? hResize : vResize;
        align.setHorizontalResize((IResize)hResize);
        align.setVerticalResize((IResize)vResize);
        shape.setAlignment(align);
    }

    protected EnumResize createResizeDefault(FieldValue fieldValue) {
        return EnumResize.FILL;
    }

    @Override
    public final Shape createShape(FieldValue value) {
        if (!this.acceptType(value)) {
            return null;
        }
        Shape shape = this.basicCreateShape(value);
        if (shape != null) {
            this.basicCustomizeShape(shape, value);
        }
        return shape;
    }

    protected abstract FieldType getFieldType();
}

