/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.tools.enumeration.common.EnumResize;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Group
extends Shape {
    public static final String ARG_IMPLICIT_RESIZE = "implicitResize";
    public static final String ARG_SHAPES = "shapes";
    public static final String TYPE = "group";
    private List<Shape> shapes = new ArrayList<Shape>();

    public static Group create(IArgs args) {
        Group shape = new Group();
        shape.init(args);
        return shape;
    }

    protected Group() {
    }

    public void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    @Override
    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        Dimension2D tmpSize = this.getSizeSpec() == null ? containerSize : this.getSize();
        Rectangle2D rect = new Rectangle2D.Double();
        for (Shape shape : this.shapes) {
            shape.layout(drawContext, tmpSize);
            Rectangle2D shapeRect = shape.getRect();
            rect = ((Rectangle2D)rect).createUnion(shapeRect);
        }
        this.setContentRect(rect);
    }

    @Override
    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
        super.drawContent(drawContext, creator);
        boolean doSaveRestore = this.shapes.size() > 1;
        for (Shape shape : this.shapes) {
            if (doSaveRestore) {
                creator.saveState();
            }
            shape.draw(drawContext, creator, this.getContentSize());
            if (!doSaveRestore) continue;
            creator.restoreState();
        }
    }

    @Override
    protected boolean getDefaultMoveContentToOrigin() {
        return false;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    protected void init(IArgs args) {
        super.init(args);
        this.setImplicitResize(ArgTools.getBoolean((IArgs)args, (String)ARG_IMPLICIT_RESIZE, (boolean)false));
        List list = ArgTools.getList((IArgs)args, (String)ARG_SHAPES, this.getShapes());
        for (Object element : list) {
            if (element instanceof Shape) {
                Shape shape = (Shape)element;
                this.addShape(shape);
                continue;
            }
            if (element instanceof IArgs) {
                IArgs shapeArgs = (IArgs)element;
                this.addShape(Shape.create(shapeArgs));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    public void setImplicitResize(boolean implicitResize) {
        if (implicitResize) {
            if (!(this.getAlignment().getHorizontalResize() instanceof ImplicitResize)) {
                this.getAlignment().setHorizontalResize((IResize)new ImplicitResize(ImplicitResize.HORIZONTAL));
            }
            if (!(this.getAlignment().getVerticalResize() instanceof ImplicitResize)) {
                this.getAlignment().setVerticalResize((IResize)new ImplicitResize(ImplicitResize.VERTICAL));
            }
        } else {
            ImplicitResize wrapper;
            IResize iResize = this.getAlignment().getHorizontalResize();
            if (iResize instanceof ImplicitResize) {
                wrapper = (ImplicitResize)iResize;
                this.getAlignment().setHorizontalResize(wrapper.getPreviousResize());
            }
            if ((iResize = this.getAlignment().getVerticalResize()) instanceof ImplicitResize) {
                wrapper = (ImplicitResize)iResize;
                this.getAlignment().setVerticalResize(wrapper.getPreviousResize());
            }
        }
    }

    private class ImplicitResize
    implements IResize {
        public static Function<RectAlignment, IResize> HORIZONTAL = alignment -> alignment.getHorizontalResize();
        public static Function<RectAlignment, IResize> VERTICAL = alignment -> alignment.getVerticalResize();
        private Function<RectAlignment, IResize> direction;
        private IResize previousResize;

        public ImplicitResize(Function<RectAlignment, IResize> direction) {
            this.direction = direction;
            this.previousResize = direction.apply(Group.this.getAlignment());
        }

        protected IResize getDelegate() {
            if (Group.this.getShapes().isEmpty()) {
                return this.previousResize;
            }
            boolean anyInflate = true;
            boolean allDeflate = true;
            for (Shape shape : Group.this.getShapes()) {
                IResize childAlignment = this.direction.apply(shape.getAlignment());
                anyInflate = anyInflate || childAlignment.isEnclose() || childAlignment.isInflate();
                allDeflate = allDeflate && (childAlignment.isDeflate() || childAlignment.isEnclose());
            }
            if (anyInflate) {
                if (allDeflate) {
                    return EnumResize.ENCLOSE;
                }
                return EnumResize.INFLATE;
            }
            if (allDeflate) {
                return EnumResize.DEFLATE;
            }
            return this.previousResize;
        }

        public IResize getPreviousResize() {
            return this.previousResize;
        }

        public boolean isDeflate() {
            return this.getDelegate().isDeflate();
        }

        public boolean isEnclose() {
            return this.getDelegate().isEnclose();
        }

        public boolean isFill() {
            return this.getDelegate().isFill();
        }

        public boolean isGrow() {
            return this.getDelegate().isGrow();
        }

        public boolean isInflate() {
            return this.getDelegate().isInflate();
        }

        public boolean isNever() {
            return this.getDelegate().isNever();
        }

        public boolean isShrink() {
            return this.getDelegate().isShrink();
        }
    }
}

