/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.ImageIOImageContainer;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.cwt.image.svg.CwtSvgImage;
import de.intarsys.cwt.image.svg.Svg;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.platform.cwt.environment.PdfGraphicsContext;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ExpandingLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Image
extends Shape {
    public static final String TYPE = "image";
    public static final String TYPE_LEGACY = "icon";
    private static final Logger Log = LoggerFactory.getLogger(Image.class);
    private Supplier<IImage> imageSupplier = () -> null;

    public static Image create(IArgs args) {
        Image shape = new Image();
        shape.init(args);
        return shape;
    }

    protected static IImage createImage(ILocator locator) {
        IImage iImage;
        block18: {
            final boolean[] svgDetected = new boolean[]{false};
            try (InputStream stream2 = locator.getInputStream();){
                SAXParserFactory.newDefaultNSInstance().newSAXParser().parse(stream2, new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("svg".equals(localName)) {
                            svgDetected[0] = true;
                        }
                        throw new CancellationException();
                    }
                });
            }
            catch (CancellationException | ParserConfigurationException | SAXException stream2) {
                // empty catch block
            }
            if (svgDetected[0]) {
                return new CwtSvgImage(Svg.createFromLocator((ILocator)locator));
            }
            ImageIOImageContainer container = ImageIOImageContainer.createFromLocator((ILocator)locator);
            try {
                iImage = container.getImageAt(0).asImage(IPlatformImage.class, new ImageConvertOption[0]);
                if (container == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (container != null) {
                        try {
                            container.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Log.warn("can't find image - " + ex.getMessage());
                    return CwtAwtImage.createErrorImage((Throwable)ex);
                }
            }
            container.close();
        }
        return iImage;
    }

    protected static ILocator getImage(IArgs args) {
        ExpandingLocatorFactory factory = new ExpandingLocatorFactory(LocatorFactory.get(), TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
        ILocator locator = ArgTools.getLocator((IArgs)args, (String)TYPE, null, (ILocatorFactory)factory);
        if (locator != null) {
            return locator;
        }
        return ArgTools.getLocator((IArgs)args, (String)TYPE_LEGACY, null, (ILocatorFactory)factory);
    }

    protected Image() {
    }

    @Override
    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        IImage image = this.getImage();
        if (image == null) {
            throw new IllegalArgumentException("Image shape needs 'image' property");
        }
        this.setContent(image);
        this.setContentRect(0.0, 0.0, image.getWidth(), image.getHeight());
    }

    @Override
    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
        IImage image = this.getImage();
        int height = image.getHeight();
        PdfGraphicsContext graphics = new PdfGraphicsContext(creator, new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, height));
        image.drawGraphics((IGraphicsContext)graphics, 0.0f, (float)height);
    }

    @Override
    protected RectAlignment getDefaultAlignment() {
        return RectAlignment.parse((String)"center;fill");
    }

    @Override
    protected String getDefaultSizeSpec() {
        return "100%*100%";
    }

    public IImage getImage() {
        return this.imageSupplier.get();
    }

    @Override
    protected void init(IArgs args) {
        super.init(args);
        this.setImage(Image.getImage(this.getArgs()));
    }

    public void setImage(ILocator locator) {
        this.imageSupplier = () -> locator == null ? null : Image.createImage(locator);
    }

    public void setImage(IImage image) {
        this.imageSupplier = () -> image;
    }
}

