/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.content.common.CSDeviceTools;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.Dimension2D;

public class Rectangle
extends Shape {
    public static final String TYPE = "rectangle";

    public static Rectangle create(IArgs args) {
        Rectangle shape = new Rectangle();
        shape.init(args);
        return shape;
    }

    protected Rectangle() {
    }

    @Override
    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        if (this.getSizeSpec() != null) {
            this.setContentSize(this.getSize());
        } else {
            super.createContent(drawContext, containerSize);
        }
    }

    @Override
    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
        if (this.getNonStrokeColor() != null) {
            CSDeviceTools.setNonStrokeColor((ICSDevice)creator, (float[])this.getNonStrokeColor());
        }
        float inset = 0.0f;
        if (this.getStrokeColor() != null) {
            CSDeviceTools.setStrokeColor((ICSDevice)creator, (float[])this.getStrokeColor());
            creator.setLineWidth(this.getStrokeWidth());
            creator.setLineCap(this.getStrokeCap());
            creator.setLineJoin(this.getStrokeJoin());
            inset = this.getStrokeWidth() / 2.0f;
        }
        creator.penRectangle(0.0f + inset, 0.0f + inset, (float)this.getSize().getWidth() - inset * 2.0f, (float)this.getSize().getHeight() - inset * 2.0f);
        if (this.getNonStrokeColor() != null) {
            if (this.getStrokeColor() != null) {
                creator.pathFillStrokeNonZero();
            } else {
                creator.pathFillNonZero();
            }
        } else if (this.getStrokeColor() != null) {
            creator.pathStroke();
        } else {
            creator.pathEnd();
        }
    }

    @Override
    protected String getDefaultSizeSpec() {
        return "10x10";
    }

    @Override
    protected String getDefaultStrokeColor() {
        return "0";
    }
}

