/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.Canvas;
import de.intarsys.pdf.design.shape.Ellipse;
import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Image;
import de.intarsys.pdf.design.shape.Rectangle;
import de.intarsys.pdf.design.shape.Text;
import de.intarsys.pdf.design.shape.sample.Path;
import de.intarsys.pdf.design.shape.sample.Samples;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.tools.enumeration.common.IResize;
import de.intarsys.tools.enumeration.common.PointAlignment;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.Dimension2D_Double;
import de.intarsys.tools.geometry.PointSpec;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Shape {
    public static final String ARG_STROKE_JOIN = "strokeJoin";
    public static final String ARG_STROKE_CAP = "strokeCap";
    public static final String ARG_STROKE_WIDTH = "strokeWidth";
    public static final String ARG_MOVE_ORIGIN_TO_MIN = "moveOriginToMin";
    public static final String ARG_NON_STROKE_COLOR = "nonStrokeColor";
    public static final String ARG_STROKE_COLOR = "strokeColor";
    public static final String ARG_ANCHOR = "anchor";
    public static final String ARG_ALIGN = "align";
    public static final String ARG_POSITION = "position";
    public static final String ARG_SIZE = "size";
    private static final String DEFAULT_POSITION_SPEC = "0x0";
    public static final String FIELD_TYPE = "type";
    private static final float DEFAULT_WIDTH = 1.0f;
    private boolean moveContentToOrigin = true;
    private Object content;
    private Rectangle2D contentRect;
    private PointSpec positionSpec;
    private PointSpec sizeSpec;
    private Rectangle2D rect = new Rectangle2D.Double();
    private RectAlignment alignment;
    private double alignOffsetX;
    private double alignOffsetY;
    private double alignScaleX;
    private double alignScaleY;
    private IArgs args;
    private PointAlignment anchor;
    private float[] nonStrokeColor;
    private float[] strokeColor;
    private float strokeWidth = 1.0f;
    private int strokeCap = 0;
    private int strokeJoin = 0;

    protected static double computeScaleX(Dimension2D sourceSize, Dimension2D destSize) {
        double scaleX = destSize.getWidth() / sourceSize.getWidth();
        if (Double.isNaN(scaleX) || Double.isInfinite(scaleX)) {
            scaleX = 1.0;
        }
        return scaleX;
    }

    protected static double computeScaleY(Dimension2D sourceSize, Dimension2D destSize) {
        double scaleY = destSize.getHeight() / sourceSize.getHeight();
        if (Double.isNaN(scaleY) || Double.isInfinite(scaleY)) {
            scaleY = 1.0;
        }
        return scaleY;
    }

    public static Shape create(Object value) {
        String type;
        if (value instanceof Shape) {
            Shape shape = (Shape)value;
            return shape;
        }
        IArgs args = ArgTools.toArgs((Object)value);
        return switch (type = ArgTools.getString((IArgs)args, (String)FIELD_TYPE, (String)"undefined")) {
            case "text" -> Text.create(args);
            case "image" -> Image.create(args);
            case "icon" -> Image.create(args);
            case "rectangle" -> Rectangle.create(args);
            case "ellipse" -> Ellipse.create(args);
            case "path" -> Path.create(args);
            case "samples" -> Samples.create(args);
            case "canvas" -> Canvas.create(args);
            case "group" -> Group.create(args);
            default -> throw new IllegalArgumentException("shape '" + value + "' not supported");
        };
    }

    protected Shape() {
    }

    protected void concatContentTransform(CDSMatrix matrix) {
        if (this.isMoveContentToOrigin()) {
            matrix.translate((float)(-this.getContentPosition().getX()), (float)(-this.getContentPosition().getY()));
        }
    }

    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        this.contentRect.setRect(0.0, 0.0, containerSize.getWidth(), containerSize.getHeight());
    }

    public void draw(IDrawContext drawContext, CSCreator creator, Dimension2D containerSize) {
        if (this.contentRect == null) {
            throw new IllegalStateException("must 'layout' first");
        }
        CDSMatrix matrix = new CDSMatrix();
        if (this.getAnchor().getHorizontal().isStart()) {
            matrix.translate((float)this.getPosition().getX(), 0.0f);
        } else if (this.getAnchor().getHorizontal().isCenter()) {
            matrix.translate((float)containerSize.getWidth() / 2.0f, 0.0f);
            matrix.translate(-((float)this.getPosition().getX()) / 2.0f, 0.0f);
            matrix.translate(-((float)this.getSize().getWidth()) / 2.0f, 0.0f);
        } else {
            matrix.translate((float)containerSize.getWidth(), 0.0f);
            matrix.translate(-((float)this.getPosition().getX()), 0.0f);
            matrix.translate(-((float)this.getSize().getWidth()), 0.0f);
        }
        if (this.getAnchor().getVertical().isStart()) {
            matrix.translate(0.0f, (float)this.getPosition().getY());
        } else if (this.getAnchor().getVertical().isCenter()) {
            matrix.translate(0.0f, (float)containerSize.getHeight() / 2.0f);
            matrix.translate(0.0f, -((float)this.getPosition().getY()) / 2.0f);
            matrix.translate(0.0f, -((float)this.getSize().getHeight()) / 2.0f);
        } else {
            matrix.translate(0.0f, (float)containerSize.getHeight());
            matrix.translate(0.0f, -((float)this.getPosition().getY()));
            matrix.translate(0.0f, -((float)this.getSize().getHeight()));
        }
        matrix.translate((float)this.getAlignOffsetX(), (float)this.getAlignOffsetY());
        matrix.scale(new float[]{(float)this.getAlignScaleX(), (float)this.getAlignScaleY()});
        this.concatContentTransform(matrix);
        if (!matrix.isIdentity()) {
            creator.transform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF());
        }
        this.drawContent(drawContext, creator);
    }

    @Deprecated
    public void draw(IDrawContext drawContext, CSCreator creator, Point2D containerSize) {
        this.draw(drawContext, creator, (Dimension2D)new Dimension2D_Double(containerSize.getX(), containerSize.getY()));
    }

    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
    }

    public RectAlignment getAlignment() {
        return this.alignment;
    }

    protected double getAlignOffsetX() {
        return this.alignOffsetX;
    }

    protected double getAlignOffsetY() {
        return this.alignOffsetY;
    }

    protected double getAlignScaleX() {
        return this.alignScaleX;
    }

    protected double getAlignScaleY() {
        return this.alignScaleY;
    }

    public PointAlignment getAnchor() {
        return this.anchor;
    }

    public IArgs getArgs() {
        return this.args;
    }

    protected Object getContent() {
        return this.content;
    }

    protected Point2D getContentPosition() {
        return new Point2D.Double(this.contentRect.getX(), this.contentRect.getY());
    }

    protected Dimension2D getContentSize() {
        return new Dimension2D_Double(this.contentRect.getWidth(), this.contentRect.getHeight());
    }

    protected RectAlignment getDefaultAlignment() {
        return new RectAlignment();
    }

    protected PointAlignment getDefaultAnchor() {
        return new PointAlignment();
    }

    protected boolean getDefaultMoveContentToOrigin() {
        return true;
    }

    protected String getDefaultNonStrokeColor() {
        return null;
    }

    protected Point2D getDefaultPosition(IDrawContext drawContext, Dimension2D containerSize) {
        return new Point2D.Double(0.0, 0.0);
    }

    protected String getDefaultPositionSpec() {
        return DEFAULT_POSITION_SPEC;
    }

    protected Dimension2D getDefaultSize(IDrawContext drawContext, Dimension2D containerSize) {
        if (this.isMoveContentToOrigin()) {
            return this.getContentSize();
        }
        return new Dimension2D_Double(this.contentRect.getMaxX(), this.contentRect.getMaxY());
    }

    protected String getDefaultSizeSpec() {
        return null;
    }

    protected String getDefaultStrokeColor() {
        return null;
    }

    protected float getDefaultStrokeWidth() {
        return 1.0f;
    }

    public float[] getNonStrokeColor() {
        return PDFColorTools.fixColorValues((float[])this.nonStrokeColor);
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.rect.getX(), this.rect.getY());
    }

    public PointSpec getPositionSpec() {
        return this.positionSpec;
    }

    public Rectangle2D getRect() {
        return (Rectangle2D)this.rect.clone();
    }

    public Dimension2D getSize() {
        return new Dimension2D_Double(this.rect.getWidth(), this.rect.getHeight());
    }

    public PointSpec getSizeSpec() {
        return this.sizeSpec;
    }

    public int getStrokeCap() {
        return this.strokeCap;
    }

    public float[] getStrokeColor() {
        return PDFColorTools.fixColorValues((float[])this.strokeColor);
    }

    public int getStrokeJoin() {
        return this.strokeJoin;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    protected void init(IArgs args) {
        this.setArgs(args);
        this.setSizeSpec(ArgTools.getString((IArgs)args, (String)ARG_SIZE, (String)this.getDefaultSizeSpec()));
        this.setPositionSpec(ArgTools.getString((IArgs)args, (String)ARG_POSITION, (String)this.getDefaultPositionSpec()));
        Object argsAlignment = ArgTools.getObject((IArgs)args, (String)ARG_ALIGN, null);
        this.setAlignment(RectAlignment.create((Object)(argsAlignment == null ? this.getDefaultAlignment() : argsAlignment)));
        Object argsAnchor = ArgTools.getObject((IArgs)args, (String)ARG_ANCHOR, null);
        this.setAnchor(PointAlignment.create((Object)(argsAnchor == null ? this.getDefaultAnchor() : argsAnchor)));
        this.setStrokeColor(PDFColorTools.parse((String)ArgTools.getString((IArgs)args, (String)ARG_STROKE_COLOR, (String)this.getDefaultStrokeColor())));
        this.setNonStrokeColor(PDFColorTools.parse((String)ArgTools.getString((IArgs)args, (String)ARG_NON_STROKE_COLOR, (String)this.getDefaultNonStrokeColor())));
        this.setMoveContentToOrigin(ArgTools.getBoolStrict((IArgs)args, (String)ARG_MOVE_ORIGIN_TO_MIN, (boolean)this.getDefaultMoveContentToOrigin()));
        this.setStrokeWidth(ArgTools.getFloatStrict((IArgs)args, (String)ARG_STROKE_WIDTH, (float)this.getDefaultStrokeWidth()));
        this.setStrokeCap(ArgTools.getIntStrict((IArgs)args, (String)ARG_STROKE_CAP, (int)this.getStrokeCap()));
        this.setStrokeJoin(ArgTools.getIntStrict((IArgs)args, (String)ARG_STROKE_JOIN, (int)this.getStrokeJoin()));
    }

    protected boolean isAdjustVertical(double sourceSize, double destSize) {
        if (sourceSize == destSize) {
            return false;
        }
        IResize verticalResize = this.getAlignment().getVerticalResize();
        if (verticalResize.isEnclose()) {
            return true;
        }
        return sourceSize > destSize ? verticalResize.isInflate() : verticalResize.isDeflate();
    }

    protected boolean isAdjustHorizontal(double sourceSize, double destSize) {
        if (sourceSize == destSize) {
            return false;
        }
        IResize horizontalResize = this.getAlignment().getHorizontalResize();
        if (horizontalResize.isEnclose()) {
            return true;
        }
        return sourceSize > destSize ? horizontalResize.isInflate() : horizontalResize.isDeflate();
    }

    public boolean isMoveContentToOrigin() {
        return this.moveContentToOrigin;
    }

    public void layout(IDrawContext drawContext, Dimension2D containerSize) {
        this.contentRect = new Rectangle2D.Double();
        if (this.getPositionSpec() != null) {
            this.setPosition(this.getPositionSpec().getPoint(containerSize));
        }
        if (this.getSizeSpec() != null) {
            this.setSize(this.getSizeSpec().getDimension(containerSize));
        }
        this.createContent(drawContext, containerSize);
        if (this.getPositionSpec() == null) {
            this.setPosition(this.getDefaultPosition(drawContext, containerSize));
        }
        if (this.getSizeSpec() == null) {
            this.setSize(this.getDefaultSize(drawContext, containerSize));
        }
        RectAlignment tmpAlignment = this.getAlignment();
        Dimension2D sourceSize = this.getContentSize();
        Dimension2D destSize = this.getSize();
        boolean proportional = tmpAlignment.isProportional();
        this.alignOffsetX = 0.0;
        this.alignOffsetY = 0.0;
        this.alignScaleX = 1.0;
        this.alignScaleY = 1.0;
        IResize hResize = tmpAlignment.getHorizontalResize();
        IResize vResize = tmpAlignment.getVerticalResize();
        if (hResize.isFill()) {
            this.alignScaleX = Shape.computeScaleX(sourceSize, destSize);
        } else if (hResize.isShrink()) {
            this.alignScaleX = Shape.computeScaleX(sourceSize, destSize);
            this.alignScaleX = Math.min(this.alignScaleX, 1.0);
        } else if (hResize.isGrow()) {
            this.alignScaleX = Shape.computeScaleX(sourceSize, destSize);
            this.alignScaleX = Math.max(this.alignScaleX, 1.0);
        }
        if (vResize.isFill()) {
            this.alignScaleY = Shape.computeScaleY(sourceSize, destSize);
        } else if (vResize.isShrink()) {
            this.alignScaleY = Shape.computeScaleY(sourceSize, destSize);
            this.alignScaleY = Math.min(this.alignScaleY, 1.0);
        } else if (vResize.isGrow()) {
            this.alignScaleY = Shape.computeScaleY(sourceSize, destSize);
            this.alignScaleY = Math.max(this.alignScaleY, 1.0);
        }
        if (proportional) {
            this.alignScaleY = this.alignScaleX = Math.min(this.alignScaleX, this.alignScaleY);
        }
        double destWidth = destSize.getWidth();
        double destHeight = destSize.getHeight();
        if (this.isAdjustHorizontal(sourceSize.getWidth(), destSize.getWidth())) {
            destWidth = sourceSize.getWidth() * this.alignScaleX;
        }
        if (this.isAdjustVertical(sourceSize.getHeight(), destSize.getHeight())) {
            destHeight = sourceSize.getHeight() * this.alignScaleY;
        }
        destSize.setSize(destWidth, destHeight);
        this.setSize(destSize);
        if (tmpAlignment.getHorizontalAlignment().isStart()) {
            this.alignOffsetX = 0.0;
        } else if (tmpAlignment.getHorizontalAlignment().isCenter()) {
            this.alignOffsetX = (destSize.getWidth() - sourceSize.getWidth() * this.alignScaleX) / 2.0;
        } else if (tmpAlignment.getHorizontalAlignment().isEnd()) {
            this.alignOffsetX = destSize.getWidth() - sourceSize.getWidth() * this.alignScaleX;
        }
        if (tmpAlignment.getVerticalAlignment().isStart()) {
            this.alignOffsetY = 0.0;
        } else if (tmpAlignment.getVerticalAlignment().isCenter()) {
            this.alignOffsetY = (destSize.getHeight() - sourceSize.getHeight() * this.alignScaleY) / 2.0;
        } else if (tmpAlignment.getVerticalAlignment().isEnd()) {
            this.alignOffsetY = destSize.getHeight() - sourceSize.getHeight() * this.alignScaleY;
        }
    }

    @Deprecated
    public void layout(IDrawContext drawContext, Point2D containerSize) {
        this.layout(drawContext, (Dimension2D)new Dimension2D_Double(containerSize.getX(), containerSize.getY()));
    }

    public void setAlignment(RectAlignment alignment) {
        this.alignment = alignment;
    }

    protected void setAlignOffsetX(double alignOffsetX) {
        this.alignOffsetX = alignOffsetX;
    }

    protected void setAlignOffsetY(double alignOffsetY) {
        this.alignOffsetY = alignOffsetY;
    }

    protected void setAlignScaleX(double alignScaleX) {
        this.alignScaleX = alignScaleX;
    }

    protected void setAlignScaleY(double alignScaleY) {
        this.alignScaleY = alignScaleY;
    }

    public void setAnchor(PointAlignment anchor) {
        this.anchor = anchor;
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }

    protected void setContent(Object content) {
        this.content = content;
    }

    protected void setContentPosition(Point2D contentPosition) {
        this.contentRect.setRect(contentPosition.getX(), contentPosition.getY(), this.contentRect.getWidth(), this.contentRect.getHeight());
    }

    protected void setContentRect(double x, double y, double width, double height) {
        this.contentRect.setRect(x, y, width, height);
    }

    protected void setContentRect(Rectangle2D contentRect) {
        this.contentRect.setRect(contentRect);
    }

    protected void setContentSize(Dimension2D contentSize) {
        this.contentRect.setRect(this.contentRect.getX(), this.contentRect.getY(), contentSize.getWidth(), contentSize.getHeight());
    }

    public void setMoveContentToOrigin(boolean includeOrigin) {
        this.moveContentToOrigin = includeOrigin;
    }

    public void setNonStrokeColor(float[] nonStrokeColor) {
        this.nonStrokeColor = nonStrokeColor;
    }

    protected void setPosition(Point2D position) {
        this.rect.setRect(position.getX(), position.getY(), this.rect.getWidth(), this.rect.getHeight());
    }

    public void setPositionSpec(PointSpec position) {
        this.positionSpec = position;
    }

    public void setPositionSpec(String definition) {
        if (StringTools.isEmpty((String)definition)) {
            this.setPositionSpec(new PointSpec(0.0, 0.0));
        } else {
            this.positionSpec = PointSpec.parse((String)definition);
        }
    }

    protected void setSize(Dimension2D size) {
        this.rect.setRect(this.rect.getX(), this.rect.getY(), size.getWidth(), size.getHeight());
    }

    public void setSizeSpec(PointSpec size) {
        this.sizeSpec = size;
    }

    public void setSizeSpec(String definition) {
        this.sizeSpec = PointSpec.parse((String)definition);
    }

    public void setStrokeCap(int strokeCap) {
        this.strokeCap = strokeCap;
    }

    public void setStrokeColor(float[] strokeColor) {
        this.strokeColor = strokeColor;
    }

    public void setStrokeJoin(int strokeJoin) {
        this.strokeJoin = strokeJoin;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }
}

