/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.app.appearance.common.AbstractLayeredAppearanceCreator;
import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.app.font.SubsetFontTools;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.design.shape.Group;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.outlet.FontOutlet;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.geometry.Dimension2D_Double;
import de.intarsys.tools.geometry.PointSpec;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ShapeAppearanceCreator
extends AbstractLayeredAppearanceCreator {
    private Group group;
    private Set<PDFont> fonts = new HashSet<PDFont>();
    private final IFontFactory fontFactory = FontOutlet.get().lookupFontFactory(null);

    public void addFont(PDFont font) {
        if (font == null) {
            return;
        }
        this.fonts.add(font);
    }

    @Override
    protected CSContent createAppearanceLayerN2Content(final PDAnnotation annotation, PDForm form) {
        IDrawContext drawContext = new IDrawContext(){

            @Override
            public void addFont(PDFont font) {
                ShapeAppearanceCreator.this.addFont(font);
            }

            @Override
            public IFontFactory getFontFactory() {
                return ShapeAppearanceCreator.this.getFontFactory();
            }

            @Override
            public ITextFormatProvider getTextFormatProvider() {
                ITextFormatProvider textFormat = AppearanceCreatorTools.getTextFormatProvider((PDAnnotation)annotation);
                if (textFormat == null && annotation.isWidgetAnnotation()) {
                    textFormat = LayoutTools.createTextFormat((PDWidgetAnnotation)annotation);
                }
                return textFormat;
            }
        };
        CDSRectangle bbox = form.getBoundingBox();
        Dimension2D_Double containerSize = new Dimension2D_Double((double)bbox.getWidth(), (double)bbox.getHeight());
        this.group.setSizeSpec(PointSpec.absolute((double)containerSize.getWidth(), (double)containerSize.getHeight()));
        this.group.layout(drawContext, (Dimension2D)containerSize);
        Dimension2D size = this.group.getSize();
        bbox.resizeTo((float)size.getWidth(), (float)size.getHeight());
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)form);
        this.group.draw(drawContext, creator, size);
        creator.close();
        for (PDFont font : this.getFonts()) {
            this.handleFont(font, creator);
        }
        return creator.getContent();
    }

    public IFontFactory getFontFactory() {
        return this.fontFactory;
    }

    public Set<PDFont> getFonts() {
        return this.fonts;
    }

    public Group getShape() {
        return this.group;
    }

    protected void handleFont(PDFont font, CSCreator creator) {
        if (this.isEmbedFonts()) {
            try {
                PlatformFontTools.embedFontFile((PDFont)font);
            }
            catch (IOException e) {
                throw new COSRuntimeException((Throwable)e);
            }
        }
        SubsetFontTools.subsetDedicatedFont(font, creator);
    }

    public void setFonts(Set<PDFont> fonts) {
        this.fonts = fonts;
    }

    public void setShape(Group group) {
        this.group = group;
    }
}

