/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.pdf.design.shape.CheckboxShapeFactory;
import de.intarsys.pdf.design.shape.DateTimeShapeFactory;
import de.intarsys.pdf.design.shape.IShapeFactory;
import de.intarsys.pdf.design.shape.ImageShapeFactory;
import de.intarsys.pdf.design.shape.NumberShapeFactory;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.SignatureShapeFactory;
import de.intarsys.pdf.design.shape.TextShapeFactory;
import de.intarsys.tools.form.model.FieldValue;
import java.util.ArrayList;
import java.util.List;

public class ShapeFactories {
    private static final List<IShapeFactory> REGISTRY = new ArrayList<IShapeFactory>();

    public static Shape createShape(FieldValue value) {
        for (IShapeFactory factory : REGISTRY) {
            Shape shape = factory.createShape(value);
            if (shape == null) continue;
            return shape;
        }
        return null;
    }

    private ShapeFactories() {
    }

    static {
        REGISTRY.add(new TextShapeFactory());
        REGISTRY.add(new CheckboxShapeFactory());
        REGISTRY.add(new NumberShapeFactory());
        REGISTRY.add(new DateTimeShapeFactory());
        REGISTRY.add(new ImageShapeFactory());
        REGISTRY.add(new SignatureShapeFactory());
    }
}

