/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape;

import de.intarsys.layout.CAlignment;
import de.intarsys.layout.CBorderPolicy;
import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.app.appearance.common.FontInfo;
import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.app.font.SubsetFontTools;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.layout.pad.IPDLTextPad;
import de.intarsys.pdf.layout.pad.PDLLayouter;
import de.intarsys.pdf.layout.pad.PDLParagraphFormat;
import de.intarsys.pdf.layout.pad.PDLTextFormat;
import de.intarsys.pdf.layout.pad.PDLTextPad;
import de.intarsys.pdf.layout.parser.PDLAbstractDocumentParser;
import de.intarsys.pdf.layout.parser.PDLParseException;
import de.intarsys.pdf.layout.parser.PDLTextBidiParser;
import de.intarsys.pdf.layout.parser.PDLTextPlainParser;
import de.intarsys.tools.enumeration.common.EnumAlignment;
import de.intarsys.tools.enumeration.common.IAlignment;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Text
extends Shape {
    public static final String ARG_FONTNAME = "fontName";
    public static final String ARG_FONTSIZE = "fontSize";
    public static final String ARG_TEXT = "text";
    public static final String ARG_TEXTALIGN = "textAlign";
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final String TYPE = "text";
    private String fontName;
    private float fontSize;
    private String text;
    private EnumAlignment textAlign;

    public static Text create(IArgs args) {
        Text shape = new Text();
        shape.init(args);
        return shape;
    }

    protected Text() {
    }

    @Override
    protected void concatContentTransform(CDSMatrix matrix) {
        super.concatContentTransform(matrix);
        matrix.translate(0.0f, -((PDLTextPad)this.getContent()).getTextFormat().getScaledFontDescent());
    }

    @Override
    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        PDLTextPad pad = this.createPad(drawContext);
        this.setContent(pad);
        drawContext.addFont(pad.getTextFormat().getFont());
        this.setContentRect(pad.getLayoutContainer().getBoundingBox());
    }

    protected PDLTextPad createPad(IDrawContext drawContext) {
        ITextFormatProvider defaultTextFormat = drawContext.getTextFormatProvider();
        FontInfo textFormatSpec = new FontInfo(this.getFontName(), drawContext.getFontFactory(), this.getFontSize(), this.getNonStrokeColor());
        PDLTextFormat textFormat = LayoutTools.createTextFormat((ITextFormatProvider)textFormatSpec.resolve(defaultTextFormat));
        PDLParagraphFormat paragraphFormat = new PDLParagraphFormat();
        EnumAlignment align = this.getTextAlign();
        if (align.isCenter()) {
            paragraphFormat.setHAlignment(CAlignment.CENTER);
        } else if (align.isStart()) {
            paragraphFormat.setHAlignment(CAlignment.LEFT);
        } else if (align.isEnd()) {
            paragraphFormat.setHAlignment(CAlignment.RIGHT);
        }
        paragraphFormat.setMaxlines(20);
        PDLLayouter layouter = new PDLLayouter((Rectangle2D)new Rectangle2D.Double());
        layouter.setPrimaryBorderPolicy(CBorderPolicy.GROW);
        layouter.setSecondaryBorderPolicy(CBorderPolicy.GROW);
        PDLTextPad pad = new PDLTextPad(textFormat, paragraphFormat, layouter);
        Object parser = textFormat.getFont() != null && SubsetFontTools.isDedicated(textFormat.getFont()) ? new PDLTextBidiParser() : new PDLTextPlainParser();
        parser.setPad((IPDLTextPad)pad);
        parser.setMode(2);
        try {
            this.parseText((PDLAbstractDocumentParser)parser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pad;
    }

    @Override
    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
        ((PDLTextPad)this.getContent()).writeOn((ICSDevice)creator);
    }

    @Override
    protected String getDefaultNonStrokeColor() {
        return "0";
    }

    @Override
    protected String getDefaultStrokeColor() {
        return null;
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.text;
    }

    public EnumAlignment getTextAlign() {
        return this.textAlign;
    }

    @Override
    protected void init(IArgs args) {
        super.init(args);
        this.setText(ArgTools.getString((IArgs)args, (String)"text", (String)""));
        this.setTextAlign(EnumAlignment.createFromArgs((IArgs)args, (String)ARG_TEXTALIGN, (IAlignment)EnumAlignment.START));
        this.setFontName(ArgTools.getString((IArgs)args, (String)ARG_FONTNAME, null));
        this.setFontSize(ArgTools.getFloatStrict((IArgs)args, (String)ARG_FONTSIZE, (float)-1.0f));
    }

    protected void parseText(PDLAbstractDocumentParser parser) throws IOException, PDLParseException {
        parser.parse((Reader)new StringReader(this.getText()));
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextAlign(EnumAlignment textAlign) {
        this.textAlign = textAlign;
    }
}

