/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape.sample;

import de.intarsys.pdf.design.shape.sample.SampleCollection;
import de.intarsys.pdf.design.shape.sample.SamplesFormat;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JSSignatureSamplesFormat
extends SamplesFormat {
    public static JSSignatureSamplesFormat create(IArgs args) {
        JSSignatureSamplesFormat samplesFormat = new JSSignatureSamplesFormat();
        samplesFormat.init(args);
        return samplesFormat;
    }

    protected void init(IArgs args) {
        SampleCollection sampleCollection = new SampleCollection();
        this.setSamples(sampleCollection);
        List transformList = ArgTools.getList((IArgs)args, (String)"transform", Arrays.asList(1, 0, 0, 1, 0, 0));
        double[] matrix = transformList.stream().mapToDouble(number -> number.doubleValue()).toArray();
        AffineTransform transform = new AffineTransform(matrix);
        IArgs samples = ArgTools.getArgs((IArgs)args, (String)"samples", (IArgs)Args.create());
        Iterator itSamples = samples.bindings();
        while (itSamples.hasNext()) {
            IArgs sample = (IArgs)((IArgs.IBinding)itSamples.next()).getValue();
            IArgs xEvents = (IArgs)sample.get("x");
            IArgs yEvents = (IArgs)sample.get("y");
            Iterator itX = xEvents.bindings();
            Iterator itY = yEvents.bindings();
            Point2D.Double ptSrc = new Point2D.Double();
            Point2D.Double ptDst = new Point2D.Double();
            while (itX.hasNext() && itY.hasNext()) {
                ((Point2D)ptSrc).setLocation(((Number)((IArgs.IBinding)itX.next()).getValue()).doubleValue(), ((Number)((IArgs.IBinding)itY.next()).getValue()).doubleValue());
                transform.transform(ptSrc, ptDst);
                sampleCollection.add(((Point2D)ptDst).getX(), ((Point2D)ptDst).getY(), 1.0);
            }
            if (ptDst == null) continue;
            sampleCollection.add(((Point2D)ptDst).getX(), ((Point2D)ptDst).getY(), 0.0);
        }
    }
}

