/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape.sample;

import de.intarsys.pdf.design.shape.sample.SampleCollection;
import de.intarsys.pdf.design.shape.sample.SamplesFormat;
import de.intarsys.pentablet.timeseries.ISamplePointCollection;
import de.intarsys.pentablet.timeseries.SignatureTimeSeries;
import de.intarsys.pentablet.timeseries.serialize.SignatureTimeSeriesBdbDeserializer;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PenTabletSignatureSamplesFormat
extends SamplesFormat {
    private static final Logger Log = LoggerFactory.getLogger(PenTabletSignatureSamplesFormat.class);

    public static PenTabletSignatureSamplesFormat create(IArgs args) {
        PenTabletSignatureSamplesFormat samplesFormat = new PenTabletSignatureSamplesFormat();
        samplesFormat.init(args);
        return samplesFormat;
    }

    protected void init(IArgs args) {
        String samples = ArgTools.getString((IArgs)args, (String)"samples", null);
        if (samples == null) {
            this.setSamples(new SampleCollection());
            return;
        }
        SignatureTimeSeriesBdbDeserializer deserializer = new SignatureTimeSeriesBdbDeserializer();
        try {
            SignatureTimeSeries timeSeries = deserializer.deserializeTimeSeries(Base64.getDecoder().decode(samples));
            this.setSamples((ISamplePointCollection)timeSeries.get(0));
        }
        catch (IOException ex) {
            Log.warn(ex.getMessage(), (Throwable)ex);
            this.setSamples(new SampleCollection());
        }
    }
}

