/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape.sample;

import de.intarsys.pdf.design.shape.sample.Sample;
import de.intarsys.pentablet.timeseries.ISamplePointCollection;
import java.util.ArrayList;
import java.util.List;

public class SampleCollection
implements ISamplePointCollection {
    private double maxF = 0.0;
    private double maxX = 0.0;
    private double maxY = 0.0;
    private double minF = 0.0;
    private double minX = 0.0;
    private double minY = 0.0;
    private List<Sample> samples = new ArrayList<Sample>();

    public void add(double x, double y, double f) {
        this.add(new Sample(x, y, f));
    }

    public void add(Sample sample) {
        this.samples.add(sample);
        if (this.samples.size() == 1) {
            this.minF = this.maxF = sample.getF();
            this.minX = this.maxX = sample.getX();
            this.minY = this.maxY = sample.getY();
        } else {
            this.minF = Math.min(this.minF, sample.getF());
            this.maxF = Math.max(this.maxF, sample.getF());
            this.minX = Math.min(this.minX, sample.getX());
            this.maxX = Math.max(this.maxX, sample.getX());
            this.minY = Math.min(this.minY, sample.getY());
            this.maxY = Math.max(this.maxY, sample.getY());
        }
    }

    public Sample get(int index) {
        return this.samples.get(index);
    }

    public double getF(int index) {
        return this.get(index).getF();
    }

    public double getMaxF() {
        return this.maxF;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinF() {
        return this.minF;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getX(int index) {
        return this.get(index).getX();
    }

    public double getY(int index) {
        return this.get(index).getY();
    }

    public int size() {
        return this.samples.size();
    }
}

