/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape.sample;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.design.shape.sample.SamplesBasedShape;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorTools;
import de.intarsys.pentablet.timeseries.ISamplePointCollection;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;

public class SampleRenderer {
    private static final double BRIGHTNESS_MIN = 0.4444444444444444;
    private static final double BRIGHTNESS_RANGE = 0.5555555555555556;
    private static final double DELTA = 0.02;
    private String curve;
    private int windingRule;

    protected static float[] getHSB(Color color, double f, double maxF) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        hsbvals[2] = (float)((double)hsbvals[2] * (0.4444444444444444 + 0.5555555555555556 * f / maxF));
        return hsbvals;
    }

    public SampleRenderer(IArgs args) {
        this.initFromArgs(args);
    }

    public String getCurve() {
        return this.curve;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    protected void initFromArgs(IArgs args) {
        this.curve = ArgTools.getString((IArgs)args, (String)"curve", null);
        this.windingRule = ArgTools.getInt((IArgs)args, (String)"windingRule", (int)1);
    }

    protected void renderPath(SamplesBasedShape shape, IGraphicsContext graphics, Path2D path) {
        PathIterator pathIterator = path.getPathIterator(null);
        double[] coords = new double[6];
        pathIterator.currentSegment(coords);
        pathIterator.next();
        if (pathIterator.isDone()) {
            path.lineTo(coords[0], coords[1]);
        }
        if (shape.getStrokeColor() != null) {
            if (shape.getNonStrokeColor() != null) {
                graphics.fillDraw((Shape)path);
            } else {
                graphics.draw((Shape)path);
            }
        } else if (shape.getNonStrokeColor() != null) {
            graphics.fill((Shape)path);
        }
    }

    public void renderSamples(SamplesBasedShape shape, IGraphicsContext graphics) {
        AbstractPathStrategy pathStrategy = "plain".equals(this.getCurve()) ? new PlainStrategy() : ("bezier".equals(this.getCurve()) ? new BezierStrategy() : new PlainStrategy());
        this.renderSamples(shape, graphics, pathStrategy);
    }

    protected void renderSamples(SamplesBasedShape shape, IGraphicsContext graphics, AbstractPathStrategy pathStrategy) {
        Color strokeColor = AwtColorTools.toColor((float[])shape.getStrokeColor());
        if (strokeColor != null) {
            graphics.setStroke((Stroke)new BasicStroke(shape.getStrokeWidth(), shape.getStrokeCap(), shape.getStrokeJoin()));
        }
        graphics.setBackgroundColor(AwtColorTools.toColor((float[])shape.getNonStrokeColor()));
        float oldBrightness = -1.0f;
        ISamplePointCollection samples = shape.getSamples();
        double maxF = samples.getMaxF();
        for (int index = 0; index < samples.size(); ++index) {
            if (samples.getF(index) == 0.0) {
                if (pathStrategy.hasPath()) {
                    pathStrategy.finish();
                    this.renderPath(shape, graphics, pathStrategy.getPath());
                    pathStrategy.reset();
                }
                oldBrightness = -1.0f;
                continue;
            }
            double x = samples.getX(index);
            double y = samples.getY(index);
            if (pathStrategy.hasPath()) {
                float[] newHSB;
                float difference;
                if (strokeColor != null && (double)(difference = Math.abs((newHSB = SampleRenderer.getHSB(strokeColor, samples.getF(index), maxF))[2] - oldBrightness)) >= 0.02) {
                    if (oldBrightness != -1.0f) {
                        Path2D path = pathStrategy.getPath();
                        this.renderPath(shape, graphics, path);
                        pathStrategy.restart(this.windingRule);
                    }
                    graphics.setForegroundColor(Color.getHSBColor(newHSB[0], newHSB[1], newHSB[2]));
                    oldBrightness = newHSB[2];
                }
                pathStrategy.draw(x, y);
                continue;
            }
            pathStrategy.start(x, y, this.windingRule);
        }
        if (pathStrategy.hasPath()) {
            pathStrategy.finish();
            this.renderPath(shape, graphics, pathStrategy.getPath());
        }
    }

    public void setCurve(String curve) {
        this.curve = curve;
    }

    private static class PlainStrategy
    extends AbstractPathStrategy {
        private PlainStrategy() {
        }

        @Override
        public void draw(double x, double y) {
            this.path.lineTo(x, y);
            this.currentX = x;
            this.currentY = y;
        }

        @Override
        public void finish() {
        }
    }

    private static class BezierStrategy
    extends AbstractPathStrategy {
        private boolean first;
        private double prevX;
        private double prevY;

        private BezierStrategy() {
        }

        @Override
        public void draw(double x, double y) {
            double midX = (this.prevX + x) / 2.0;
            double midY = (this.prevY + y) / 2.0;
            if (this.first) {
                this.first = false;
                this.path.lineTo(midX, midY);
            } else {
                this.path.quadTo(this.prevX, this.prevY, midX, midY);
            }
            this.currentX = midX;
            this.currentY = midY;
            this.prevX = x;
            this.prevY = y;
        }

        @Override
        public void finish() {
            this.path.lineTo(this.prevX, this.prevY);
        }

        @Override
        public void start(double x, double y, int windingRule) {
            super.start(x, y, windingRule);
            this.prevX = x;
            this.prevY = y;
            this.first = true;
        }
    }

    private static abstract class AbstractPathStrategy {
        protected double currentX;
        protected double currentY;
        protected Path2D path;

        private AbstractPathStrategy() {
        }

        public abstract void draw(double var1, double var3);

        public abstract void finish();

        public Path2D getPath() {
            return this.path;
        }

        public boolean hasPath() {
            return this.path != null;
        }

        public void reset() {
            this.path = null;
        }

        public void restart(int windingRule) {
            this.path = new Path2D.Double();
            this.path.setWindingRule(windingRule);
            this.path.moveTo(this.currentX, this.currentY);
        }

        public void start(double x, double y, int windingRule) {
            this.path = new Path2D.Double();
            this.path.setWindingRule(windingRule);
            this.path.moveTo(x, y);
        }
    }
}

