/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.shape.sample;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.design.shape.IDrawContext;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.sample.SampleRenderer;
import de.intarsys.pdf.platform.cwt.environment.PdfGraphicsContext;
import de.intarsys.pentablet.timeseries.ISamplePointCollection;
import de.intarsys.tools.functor.IArgs;
import java.awt.geom.Dimension2D;

public abstract class SamplesBasedShape
extends Shape {
    private ISamplePointCollection samples;

    @Override
    protected void createContent(IDrawContext drawContext, Dimension2D containerSize) {
        double minX = this.samples.getMinX();
        double minY = this.samples.getMinY();
        double maxX = this.samples.getMaxX();
        double maxY = this.samples.getMaxY();
        float inset = 0.0f;
        if (this.getStrokeColor() != null) {
            inset = this.getStrokeWidth() / 2.0f;
        }
        this.setContentRect(minX - (double)inset, minY - (double)inset, maxX - minX + (double)(inset * 2.0f), maxY - minY + (double)(inset * 2.0f));
    }

    @Override
    protected void drawContent(IDrawContext drawContext, CSCreator creator) {
        SampleRenderer renderer = new SampleRenderer(this.getRendererArgs());
        PdfGraphicsContext graphics = new PdfGraphicsContext(creator);
        renderer.renderSamples(this, (IGraphicsContext)graphics);
    }

    @Override
    protected String getDefaultNonStrokeColor() {
        return null;
    }

    protected IArgs getRendererArgs() {
        return this.getArgs();
    }

    public ISamplePointCollection getSamples() {
        return this.samples;
    }

    protected void setSamples(ISamplePointCollection samples) {
        this.samples = samples;
    }
}

