/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.fixes.PDFFixException;
import de.intarsys.tools.action.Action;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IFunctorCall;

public abstract class Fix
extends Action {
    public static final String FIXED = "fixed";
    public static final String FAILED = "failed";
    private Object result;
    private boolean performed = false;
    private Object damaged;

    public static boolean isFixed(Object result) {
        return result != null && result.equals(FIXED);
    }

    protected Fix(Object owner, Object damaged) {
        super(owner);
        this.damaged = damaged;
    }

    public Object getDamaged() {
        return this.damaged;
    }

    public boolean isEnabled(IFunctorCall call) {
        if (this.performed) {
            return false;
        }
        return super.isEnabled(call);
    }

    public Object perform() throws FunctorException {
        if (this.performed) {
            return this.result;
        }
        this.performed = true;
        try {
            this.result = this.process();
            if (!this.result.equals(FIXED)) {
                throw new FunctorExecutionException((Throwable)((Object)new PDFFixException((String)this.result)));
            }
        }
        catch (FunctorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FunctorExecutionException((Throwable)e);
        }
        return this.result;
    }

    protected abstract String process();

    public void setDamaged(Object damaged) {
        this.damaged = damaged;
    }
}

