/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.app.colorspace.ColorSpaceCache;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import java.util.List;

public class PDCreateDefaultColorspaces
extends PDDocFix {
    public static final String ATTR_USEDRESOURCES = "usedRes";
    public static final String CN_RES_DEFGRAY_MISSING = "defGrayMissing";
    public static final String CN_RES_DEFRGB_MISSING = "defRGBMissing";
    public static final String CN_RES_DEFCMYK_MISSING = "defCMYKMissing";
    private ColorSpaceCache cache;

    public PDCreateDefaultColorspaces(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    protected ColorSpaceCache getCache() {
        if (this.cache == null) {
            this.cache = ColorSpaceCache.get(this.getPDDoc());
        }
        return this.cache;
    }

    protected void importCMYK_ICCProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceCmykIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultCMYK, colorSpace);
    }

    protected void importGray_ICCProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceGrayIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultGray, colorSpace);
    }

    protected void importRGB_ICCProfile(PDResources resources) {
        PDColorSpace colorSpace = this.getCache().getColorSpaceRgbIcc();
        if (colorSpace == null) {
            return;
        }
        resources.addColorSpaceResource(PDColorSpace.CN_CS_DefaultRGB, colorSpace);
    }

    @Override
    protected String process() {
        String result = "fixed";
        List usedResources = (List)this.getAttribute(ATTR_USEDRESOURCES);
        if (usedResources == null || usedResources.isEmpty()) {
            return "failed";
        }
        for (PDResources resources : usedResources) {
            if (resources.getAttribute((Object)CN_RES_DEFGRAY_MISSING) != null) {
                this.importGray_ICCProfile(resources);
            }
            if (resources.getAttribute((Object)CN_RES_DEFCMYK_MISSING) != null) {
                this.importCMYK_ICCProfile(resources);
            }
            if (resources.getAttribute((Object)CN_RES_DEFRGB_MISSING) == null) continue;
            this.importRGB_ICCProfile(resources);
        }
        return result;
    }
}

