/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.pd.AnnotationFlags;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PDFixAnnotationFlags
extends PDDocFix {
    public PDFixAnnotationFlags(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    protected COSDictionary createAppearance(PDAnnotation annotation) {
        IAppearanceCreator appearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator(annotation.cosGetSubtype());
        if (appearanceCreator == null) {
            return null;
        }
        PDAppearance appearance = appearanceCreator.createAppearance(annotation, null);
        return appearance.cosGetDict();
    }

    private void dispose(PDAnnotation anno) {
        anno.dispose();
    }

    protected COSStream findAppearance(COSDictionary apdict, COSObject state) {
        if (apdict.get(PDAppearance.DK_N).asDictionary() != null) {
            Iterator iterator = apdict.get(PDAppearance.DK_N).asDictionary().entryIterator();
            while (iterator.hasNext()) {
                Map.Entry element = (Map.Entry)iterator.next();
                if (!element.getKey().equals(state)) continue;
                return (COSStream)element.getValue();
            }
            return null;
        }
        return apdict.get(PDAppearance.DK_N).asStream();
    }

    @Override
    protected String process() {
        String result = "fixed";
        PDPage page = this.getPDDoc().getPageTree().getFirstPage();
        while (page != null) {
            List annotations = page.getAnnotations();
            if (annotations == null) {
                page = page.getNextPage();
                continue;
            }
            for (PDAnnotation annotation : annotations) {
                COSObject state;
                COSStream copyStream;
                COSDictionary annotdict = annotation.cosGetDict();
                if (!annotdict.containsKey(PDAnnotation.DK_F)) {
                    flags = new AnnotationFlags(annotation);
                    flags.setPrint(true);
                } else {
                    flags = annotation.getFlags();
                    if (!flags.isPrint()) {
                        this.dispose(annotation);
                    }
                    if (flags.isInvisible() || flags.isHidden() || flags.isNoView()) {
                        this.dispose(annotation);
                    }
                }
                if (annotdict.containsKey(PDAnnotation.DK_C)) {
                    annotdict.remove(PDAnnotation.DK_C);
                }
                if (!annotdict.containsKey(PDAnnotation.DK_AP) || (!annotdict.containsKey(PDAcroFormField.DK_FT) || !annotdict.get(PDAcroFormField.DK_FT).asName().equals((Object)PDAcroFormField.CN_FT_Btn)) && (!(annotation instanceof PDWidgetAnnotation) || !((PDWidgetAnnotation)annotation).getAcroFormField().getLogicalRoot().isTypeBtn())) continue;
                COSDictionary apdict = annotdict.get(PDAnnotation.DK_AP).asDictionary();
                if (apdict.containsKey(PDAppearance.DK_D)) {
                    apdict.remove(PDAppearance.DK_D);
                }
                if (apdict.containsKey(PDAppearance.DK_R)) {
                    apdict.remove(PDAppearance.DK_R);
                }
                if ((copyStream = this.findAppearance(apdict, state = annotdict.get(PDWidgetAnnotation.DK_AS))) == null) {
                    apdict = this.createAppearance(annotation);
                    copyStream = this.findAppearance(apdict, state);
                }
                if (copyStream == null) {
                    result = "failed";
                    continue;
                }
                apdict.put(PDAppearance.DK_N, (COSObject)copyStream);
            }
            page = page.getNextPage();
        }
        return result;
    }
}

