/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.cwt.font.truetype.TTCMap;
import de.intarsys.cwt.font.truetype.TTCharacterToGlyphIndexMapping;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTSerializable;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PDFixCharEncodings
extends PDDocFix {
    public static String ATTR_FONTS = "fonts";

    public PDFixCharEncodings(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    @Override
    protected String process() {
        String result = "fixed";
        List fonts = (List)this.getAttribute(ATTR_FONTS);
        if (fonts == null) {
            return "failed";
        }
        for (PDFont pdFont : fonts) {
            String encoding = pdFont.cosGetField(PDFont.DK_Encoding).stringValue();
            if (pdFont.getFontDescriptor().getFlags().isNonsymbolic()) {
                if (!encoding.equals("null") && (encoding.equals("WinAnsiEncoding") || encoding.equals("MacRomanEncoding"))) continue;
                pdFont.setEncoding(Encoding.createNamed((COSName)Encoding.CN_WinAnsiEncoding));
                continue;
            }
            if (!encoding.equals("null")) {
                pdFont.cosSetField(PDFont.DK_Encoding, (COSObject)COSNull.create());
            }
            TTFont ttFont = PDFontTrueTypeTools.getTTFont((PDFont)pdFont);
            try {
                TTCharacterToGlyphIndexMapping mapping = ttFont.getCharacterToGlyphIndexMapping();
                if (mapping == null) continue;
                boolean changed = false;
                for (TTCMap cmap : mapping.getCMaps()) {
                    if (cmap.getPlatformId() == 1 && cmap.getPlatformId() == 0) continue;
                    mapping.removeCMap(cmap);
                    changed = true;
                }
                if (!changed) continue;
                ttFont.put((TTSerializable)mapping);
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    new TTFontSerializer().write((OutputStream)bos, ttFont);
                    pdFont.getFontDescriptor().setFontFile2(bos.toByteArray());
                }
            }
            catch (IOException e) {
                result = "failed";
            }
            catch (TTException e) {
                result = "failed";
            }
        }
        return result;
    }
}

