/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.app.font.SubsetTTFontsUsedCharacters;
import de.intarsys.pdf.fixes.FontMetricsBean;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.fixes.PDFixFontMetrics;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.reporter.Reporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PDFixEmbedAllFonts
extends PDDocFix {
    private boolean embedUsedOnly;
    private List fontbeans;

    public PDFixEmbedAllFonts(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    @Override
    protected String process() {
        ArrayList<FontMetricsBean> fontBeans = this.getFontbeans();
        if (fontBeans == null) {
            List fonts = PDFontTools.getUsedFonts((PDDocument)this.getPDDoc(), (boolean)true);
            fontBeans = new ArrayList<FontMetricsBean>();
            for (PDFont font : fonts) {
                FontMetricsBean bean = new FontMetricsBean();
                bean.setFont(font);
                bean.setMin(font.getFirstChar());
                bean.setMax(font.getLastChar());
                fontBeans.add(bean);
            }
        }
        HashMap<PDFont, String> alreadyEmbedded = new HashMap<PDFont, String>();
        for (FontMetricsBean bean : fontBeans) {
            PDFont pdFont = bean.getFont();
            if (pdFont.isEmbedded() || alreadyEmbedded.containsKey(pdFont)) continue;
            try {
                PlatformFontTools.embedFontFile((PDFont)pdFont);
                PDFixFontMetrics.fillWidths(pdFont, bean.getMin(), bean.getMax());
                this.getPDDoc().cosGetDoc().stGetDoc().setDirty(true);
                alreadyEmbedded.put(pdFont, "");
            }
            catch (IOException e) {
                Reporter.get().reportError("Font not found", pdFont.getFontName(), (Throwable)e, 0);
            }
        }
        if (this.isEmbedUsedOnly()) {
            SubsetTTFontsUsedCharacters functor = new SubsetTTFontsUsedCharacters();
            FunctorCall call = FunctorCall.create((Object)this.getPDDoc(), (Object[])new Object[0]);
            try {
                functor.perform((IFunctorCall)call);
            }
            catch (FunctorException e1) {
                Reporter.get().reportError("Strict subsetting failed", "", (Throwable)e1, 0);
            }
        }
        return "fixed";
    }

    public void setEmbedUsedOnly(boolean embedUsedOnly) {
        this.embedUsedOnly = embedUsedOnly;
    }

    public boolean isEmbedUsedOnly() {
        return this.embedUsedOnly;
    }

    public void setFontbeans(List fontbeans) {
        this.fontbeans = fontbeans;
    }

    public List getFontbeans() {
        return this.fontbeans;
    }
}

