/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.pd.PDDocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDFixEmbedFileStreams
extends PDDocFix {
    public static final String ATTR_ERRORSTREAMS = "erSt";

    public PDFixEmbedFileStreams(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    @Override
    protected String process() {
        String result = "fixed";
        ArrayList<COSStream> tmpstreams = new ArrayList<COSStream>();
        List errorstreams = (List)this.getAttribute(ATTR_ERRORSTREAMS);
        if (errorstreams != null) {
            for (COSStream stream : errorstreams) {
                COSDictionary dict = stream.getDict();
                COSObject fileSpec = dict.get(COSStream.DK_F);
                String filepath = "";
                if (!(fileSpec instanceof COSString)) {
                    this.removeFKeys(dict);
                    continue;
                }
                filepath = ((COSString)fileSpec).stringValue();
                File externalFile = new File(filepath);
                if (!externalFile.exists()) {
                    this.removeFKeys(dict);
                    continue;
                }
                stream.getDecodedBytes();
                dict.remove(COSStream.DK_F);
                if (dict.containsKey(COSStream.DK_FFilter)) {
                    dict.put(COSStream.DK_Filter, dict.get(COSStream.DK_FFilter));
                    dict.remove(COSStream.DK_FFilter);
                }
                if (dict.containsKey(COSStream.DK_FDecodeParms)) {
                    dict.put(COSStream.DK_DecodeParms, dict.get(COSStream.DK_FDecodeParms));
                    dict.remove(COSStream.DK_FDecodeParms);
                }
                tmpstreams.add(stream);
            }
            Iterator iter = tmpstreams.iterator();
            while (iter.hasNext()) {
                errorstreams.remove(iter.next());
            }
        }
        return result;
    }

    protected void removeFKeys(COSDictionary dict) {
        if (dict.containsKey(COSStream.DK_F)) {
            dict.remove(COSStream.DK_F);
        }
        if (dict.containsKey(COSStream.DK_FFilter)) {
            dict.remove(COSStream.DK_FFilter);
        }
        if (dict.containsKey(COSStream.DK_FDecodeParms)) {
            dict.remove(COSStream.DK_FDecodeParms);
        }
    }
}

