/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.fixes.FontMetricsBean;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import java.util.List;

public class PDFixFontMetrics
extends PDDocFix {
    public static final String ATTR_FONTS = "fonts";

    protected static void fillWidths(PDFont pdFont, int min, int max) {
        try {
            IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(pdFont);
            int last = pdFont.getLastChar();
            int first = pdFont.getFirstChar();
            if (min != -1 && min < first) {
                first = min;
                pdFont.cosSetField(PDFont.DK_FirstChar, (COSObject)COSInteger.create((int)first));
            }
            if (max != -1 && max > last) {
                last = max;
                pdFont.cosSetField(PDFont.DK_LastChar, (COSObject)COSInteger.create((int)last));
            }
            COSArray widths = COSArray.create((int)(last - first + 1));
            for (int i = first; i <= last; ++i) {
                PDGlyphs pdglyphs = pdFont.getGlyphsEncoded(i);
                try {
                    IPlatformGlyphs pfglyphs = pfFont.createPlatformGlyphs(pdglyphs);
                    widths.add((COSObject)COSInteger.create((int)pfglyphs.getWidth()));
                    continue;
                }
                catch (Exception e) {
                    widths.add((COSObject)COSInteger.create((int)pdFont.getMissingWidth()));
                }
            }
            pdFont.cosSetField(PDFont.DK_Widths, (COSObject)widths);
        }
        catch (PlatformFontException platformFontException) {
            // empty catch block
        }
    }

    public PDFixFontMetrics(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    @Override
    protected String process() {
        List fontsBeans = (List)this.getAttribute(ATTR_FONTS);
        if (fontsBeans != null) {
            for (FontMetricsBean fontBean : fontsBeans) {
                PDFixFontMetrics.fillWidths(fontBean.getFont(), fontBean.getMin(), fontBean.getMax());
            }
        }
        return "fixed";
    }
}

