/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.xmp.XMPStructure;
import de.intarsys.pdf.xmp.XMPStructureException;
import de.intarsys.tools.date.DateEnvironment;
import java.io.IOException;
import java.util.Calendar;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.XMPSchemaMediaManagement;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.jempbox.xmp.property.PropertyResourceEvent;

public class PDFixGenerateXMP
extends PDDocFix {
    public static final String ATTR_PDFA_XMP = "pdfaxmp";
    public static final String ATTR_FROM_SCRATCH = "scratch";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<prefix>.*?)(?<number>\\d+)");

    public PDFixGenerateXMP(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    private void addHistory(XMPSchemaMediaManagement mm, String action) {
        PropertyResourceEvent beginning = new PropertyResourceEvent((XMPSchema)mm);
        beginning.setAction(action);
        beginning.setSoftwareAgent("intarsys GmbH");
        beginning.setParameters("XMP by intarsys GmbH");
        Calendar now = Calendar.getInstance();
        now.setTime(DateEnvironment.get().now());
        beginning.setWhen(now);
        mm.addHistory(beginning);
    }

    protected void createPDFA(XMPStructure xmp) throws IOException {
        XMPSchemaMediaManagement mm = xmp.getXMPMetadata().getMediaManagementSchema();
        if (mm == null) {
            mm = xmp.getXMPMetadataAsPDFA().addMediaManagementSchema();
            mm.setDocumentID(UUID.randomUUID().toString());
            mm.setVersionID("0");
            this.addHistory(mm, "managed");
        } else {
            if (mm.getDocumentID() == null || mm.getDocumentID().isEmpty()) {
                mm.setDocumentID(UUID.randomUUID().toString());
                this.addHistory(mm, "managed");
                this.incrementVersion(mm);
            }
            if (mm.getHistory() == null || mm.getHistory().isEmpty()) {
                this.addHistory(mm, "edited");
                this.incrementVersion(mm);
            }
            if (mm.getVersionID() == null || mm.getVersionID().isEmpty()) {
                this.incrementVersion(mm);
            }
        }
        XMPSchemaPDFAId pdfaId = xmp.getXMPMetadataAsPDFA().getPDFAIdSchema();
        if (pdfaId == null) {
            pdfaId = xmp.getXMPMetadataAsPDFA().addPDFAIdSchema();
        }
        pdfaId.setPart(Integer.valueOf(1));
        pdfaId.setConformance("B");
        pdfaId.setAmd(null);
    }

    private String incrementVersion(String id) {
        if (id == null || id.isEmpty()) {
            return "0";
        }
        Matcher matcher = VERSION_PATTERN.matcher(id);
        if (matcher.matches()) {
            String prefix = matcher.group("prefix");
            long number = Long.parseLong(matcher.group("number"));
            return prefix + Long.toString(number + 1L);
        }
        return id + ".0";
    }

    private void incrementVersion(XMPSchemaMediaManagement mm) {
        String oldVersion = mm.getVersionID();
        String newVersion = this.incrementVersion(oldVersion);
        mm.setVersionID(newVersion);
    }

    @Override
    protected String process() {
        XMPStructure xmp = XMPStructure.createFromCos((COSDocument)this.getPDDoc().cosGetDoc());
        if (this.getAttribute(ATTR_FROM_SCRATCH) != null) {
            xmp.setMetadata(null);
        }
        try {
            if (this.getAttribute(ATTR_PDFA_XMP) != null) {
                this.createPDFA(xmp);
            }
            xmp.updateFromInfoDict();
            xmp.persist();
        }
        catch (XMPStructureException | IOException exception) {
            return "Couldn't fix XMP metadata";
        }
        return "fixed";
    }
}

