/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fixes;

import de.intarsys.pdf.app.colorspace.ColorSpaceCache;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.fixes.PDDocFix;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDOutputIntent;

public class PDFixImportOI
extends PDDocFix {
    public static final String ATTR_TYPE = "type";

    public PDFixImportOI(Object owner, PDDocument doc) {
        super(owner, doc);
    }

    protected boolean importCMYK_ICCProfile(PDOutputIntent pdOutputIntent) {
        COSStream profile = ColorSpaceCache.loadCmykIccStream();
        if (profile == null) {
            return false;
        }
        pdOutputIntent.cosSetField(PDOutputIntent.DK_DestOutputProfile, (COSObject)profile);
        return true;
    }

    protected boolean importGray_ICCProfile(PDOutputIntent pdOutputIntent) {
        COSStream profile = ColorSpaceCache.loadGrayIccStream();
        if (profile == null) {
            return false;
        }
        pdOutputIntent.cosSetField(PDOutputIntent.DK_DestOutputProfile, (COSObject)profile);
        return true;
    }

    protected boolean importRGB_ICCProfile(PDOutputIntent pdOutputIntent) {
        COSStream profile = ColorSpaceCache.loadRgbIccStream();
        if (profile == null) {
            return false;
        }
        pdOutputIntent.cosSetField(PDOutputIntent.DK_DestOutputProfile, (COSObject)profile);
        return true;
    }

    @Override
    protected String process() {
        String result = "fixed";
        COSArray ois = COSArray.create((int)1);
        this.getPDDoc().getCatalog().cosSetField(COSCatalog.DK_OutputIntents, (COSObject)ois);
        PDOutputIntent pdfa_oi = (PDOutputIntent)PDOutputIntent.META.createNew();
        pdfa_oi.cosSetField(PDOutputIntent.DK_S, (COSObject)COSName.constant((String)"GTS_PDFA1"));
        pdfa_oi.cosSetField(PDOutputIntent.DK_OutputConditionIdentifier, (COSObject)COSString.create((String)"Custom"));
        boolean ok = false;
        String cstype = (String)this.getAttribute(ATTR_TYPE);
        if (cstype.equals("CMYK")) {
            pdfa_oi.cosSetField(PDOutputIntent.DK_OutputCondition, (COSObject)COSString.create((String)"PDF/A CMYK"));
            pdfa_oi.cosSetField(PDOutputIntent.DK_Info, (COSObject)COSString.create((String)"PDF/A CMYK ICC Profile, ISOcoated_v2_eci.icc"));
            ok = this.importCMYK_ICCProfile(pdfa_oi);
        } else if (cstype.equals("RGB")) {
            pdfa_oi.cosSetField(PDOutputIntent.DK_OutputCondition, (COSObject)COSString.create((String)"PDF/A sRGB"));
            pdfa_oi.cosSetField(PDOutputIntent.DK_Info, (COSObject)COSString.create((String)"PDF/A sRGB ICC Profile, sRGB_IEC61966-2-1_withBPC.icc"));
            ok = this.importRGB_ICCProfile(pdfa_oi);
        } else {
            pdfa_oi.cosSetField(PDOutputIntent.DK_OutputCondition, (COSObject)COSString.create((String)"PDF/A Gray"));
            pdfa_oi.cosSetField(PDOutputIntent.DK_Info, (COSObject)COSString.create((String)"PDF/A Gray ICC Profile, abd_Gray.icc"));
            ok = this.importGray_ICCProfile(pdfa_oi);
        }
        if (!ok) {
            result = "Could not embedd Colorspace in OI";
        } else {
            ois.add(pdfa_oi.cosGetObject());
        }
        return result;
    }
}

