/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.application;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.ICOSDocumentFactory;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.tools.application.CachedDocument;
import de.intarsys.tools.cache.Cache;
import de.intarsys.tools.component.ISynchronizable;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDocumentFactory
implements ICOSDocumentFactory,
ISynchronizable {
    private static final Logger Log = LoggerFactory.getLogger(CachedDocumentFactory.class);
    private final Cache cache;
    private final ICOSDocumentFactory delegate;
    private final String name;

    public CachedDocumentFactory(String name, int size, ICOSDocumentFactory delegate) {
        this.name = name;
        this.cache = new Cache(size);
        this.delegate = delegate;
    }

    public synchronized COSDocument createDocument(ILocator locator, Map options) throws COSLoadException, IOException {
        CachedDocument result = (CachedDocument)this.cache.get((Object)locator);
        if (result == null) {
            COSDocument doc = this.delegate.createDocument(locator, options);
            result = new CachedDocument(doc, locator);
            this.cache.put((Object)locator, (Object)result);
        }
        return result.getDocument().copyDeep();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOutOfSynch() {
        return this.cache.isOutOfSynch();
    }

    public synchronized void synch() {
        Log.trace("synchronizing document cache '" + this.getName() + "'");
        this.cache.synch();
    }
}

