/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.application;

import de.intarsys.pdf.app.appearance.common.AppearanceTools;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.hex.HexTools;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class SimpleWaterMark {
    private static final COSName MARK_NAME = COSName.constant((String)"WaterMark");
    private static final COSName FONTNAME = COSName.constant((String)"Helvetica");
    private static final float halfSqrt2 = (float)(0.5 * Math.sqrt(2.0));
    private String text;
    private PDDocument doc;
    private PDForm form;
    private int[] colorValues = new int[]{255, 204, 0};
    private float strokingAlpha = 0.6f;
    private float nonStrokingAlpha = 0.2f;

    public SimpleWaterMark(PDDocument doc, String text) {
        this.doc = doc;
        this.text = text;
    }

    public SimpleWaterMark(PDDocument doc, String text, int[] colorValues) {
        this.doc = doc;
        this.text = text;
        this.setColorValues(colorValues);
    }

    private void createForm() {
        this.form = (PDForm)PDForm.META.createNew();
        PDFont font = PDFontTools.createBuiltinFont((String)FONTNAME.stringValue());
        PDExtGState extGState = (PDExtGState)PDExtGState.META.createNew();
        extGState.setStrokingAlphaConstant(this.getStrokingAlpha());
        extGState.setNonStrokingAlphaConstant(this.getNonStrokingAlpha());
        Rectangle2D rect = AppearanceTools.calcRect(font, 100.0f, this.getText());
        float rectWidth = rect == null ? 400.0f : (float)rect.getWidth();
        float rectHeight = rect == null ? 600.0f : (float)rect.getHeight();
        float offset = (float)((double)(halfSqrt2 * rectHeight) / 2.0);
        float newWidth = halfSqrt2 * rectWidth + offset;
        CSCreator creator = CSCreator.createFromProvider((IContentStreamProvider)this.form);
        creator.textBegin();
        creator.setExtendedState(null, extGState);
        creator.setNonStrokeColorRGB(this.getColorValue(0), this.getColorValue(1), this.getColorValue(2));
        creator.setStrokeColorRGB(this.getColorValue(0), this.getColorValue(1), this.getColorValue(2));
        creator.textSetFont(null, font, 100.0f);
        creator.setLineWidth(2.0f);
        creator.textSetTransform(halfSqrt2, halfSqrt2, -halfSqrt2 + 1.0E-4f, halfSqrt2 + 1.0E-4f, offset, 0.0f);
        creator.textSetRenderingMode(2);
        creator.textShow(this.getText());
        creator.textEnd();
        creator.close();
        this.form.setBoundingBox(new CDSRectangle(0.0f, 0.0f, newWidth, newWidth));
    }

    public void doIt() {
        if (this.pagesContainForm() && this.isFormUnchanged()) {
            return;
        }
        this.markPages();
    }

    protected float getColorValue(int index) {
        int cv = this.getColorValues()[index];
        return (float)cv / 255.0f;
    }

    public int[] getColorValues() {
        return this.colorValues;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public PDForm getForm() {
        if (this.form == null) {
            this.createForm();
        }
        return this.form;
    }

    public float getNonStrokingAlpha() {
        return this.nonStrokingAlpha;
    }

    public float getStrokingAlpha() {
        return this.strokingAlpha;
    }

    public String getText() {
        return this.text;
    }

    private boolean isFormUnchanged() {
        PDPage page = this.getDoc().getPageTree().getFirstPage();
        PDResources resources = page.getResources();
        if (resources == null) {
            return false;
        }
        PDXObject mark = resources.getXObjectResource(MARK_NAME);
        if (mark == null) {
            return false;
        }
        return Arrays.equals(this.getForm().getBytes(), mark.getBytes());
    }

    private void markPage(PDPage page) {
        float formWidth = this.getForm().getBoundingBox().getWidth();
        CDSRectangle rect = page.getCropBox();
        float area = Math.min(rect.getWidth(), rect.getHeight()) * 0.95f;
        float scale = area / formWidth;
        float offsetY = (rect.getHeight() - formWidth * scale) / 2.0f;
        float offsetX = (rect.getWidth() - formWidth * scale) / 2.0f;
        CSCreator creator = CSCreator.createNewDetached((IResourcesProvider)page);
        creator.saveState();
        creator.transform(scale, 0.0f, 0.0f, scale, offsetX, offsetY);
        creator.doXObject(MARK_NAME, (PDXObject)this.getForm());
        creator.restoreState();
        creator.close();
        page.cosAddContents(creator.getContent().createStream());
    }

    private void markPages() {
        for (PDPage page = this.getDoc().getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            this.markPage(page);
        }
    }

    private boolean pagesContainForm() {
        for (PDPage page = this.getDoc().getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            PDResources resources = page.getResources();
            if (resources != null && resources.getXObjectResource(MARK_NAME) != null) continue;
            return false;
        }
        return true;
    }

    public void setColor(String hexColorValues) {
        byte[] bytes = HexTools.hexStringToBytes((String)hexColorValues);
        int[] integers = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            integers[i] = bytes[i] & 0xFF;
        }
        this.setColorValues(integers);
    }

    public void setColorValues(int[] colorValues) {
        if (colorValues == null) {
            colorValues = new int[]{0, 0, 0};
        }
        if (colorValues.length == 1) {
            colorValues = new int[]{colorValues[0], colorValues[0], colorValues[0]};
        }
        if (colorValues.length != 3) {
            throw new IllegalArgumentException("illegal color array length");
        }
        this.colorValues = colorValues;
    }

    public void setNonStrokingAlpha(float nonStrokingAlpha) {
        this.nonStrokingAlpha = nonStrokingAlpha;
    }

    public void setStrokingAlpha(float strokingAlpha) {
        this.strokingAlpha = strokingAlpha;
    }

    public void setText(String text) {
        this.text = text;
    }
}

