/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.attr.AttributeSigningCertificate;
import de.intarsys.asn1.cms.attr.AttributeSigningCertificateV2;
import de.intarsys.asn1.cms.attr.ESSCertID;
import de.intarsys.asn1.cms.attr.ESSCertIDv2;
import de.intarsys.asn1.cms.attr.SigningCertificate;
import de.intarsys.asn1.cms.attr.SigningCertificateV2;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningCertificateEncoder
implements IAttributeEncoder {
    private static final Logger Log = LoggerFactory.getLogger(SigningCertificateEncoder.class);

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        IX509PublicKeyCertificate[] certs = builder.getSigner().getCertificatePath();
        IX509PublicKeyCertificate cert = null;
        if (certs != null && certs.length > 0) {
            cert = certs[0];
        }
        if (cert == null) {
            return null;
        }
        String algorithmName = builder.getDigest().getAlgorithmName();
        String algorithmOid = DigestAlgorithm.lookupOID((String)algorithmName);
        IssuerSerial issuerSerial = this.getIssuerSerial((IX509Certificate)cert);
        byte[] certHash = this.getCertHash((IX509Certificate)cert, algorithmName);
        if (certHash == null) {
            return null;
        }
        if ("1.3.14.3.2.26".equals(algorithmOid)) {
            AttributeSigningCertificate attr = (AttributeSigningCertificate)AttributeSigningCertificate.FACTORY.createNew();
            SigningCertificate signingCert = (SigningCertificate)SigningCertificate.FACTORY.createNew();
            attr.addSigningCertificate(signingCert);
            ESSCertID certId = (ESSCertID)ESSCertID.FACTORY.createNew();
            signingCert.addCert(certId);
            certId.setCertHash(certHash);
            certId.setIssuerSerial(issuerSerial);
            return attr;
        }
        AttributeSigningCertificateV2 attr = (AttributeSigningCertificateV2)AttributeSigningCertificateV2.FACTORY.createNew();
        SigningCertificateV2 signingCert = (SigningCertificateV2)SigningCertificateV2.FACTORY.createNew();
        attr.addSigningCertificate((SigningCertificate)signingCert);
        ESSCertIDv2 certId = (ESSCertIDv2)ESSCertIDv2.FACTORY.createNew();
        signingCert.addCert((ESSCertID)certId);
        certId.setHashAlgorithmOID(algorithmOid);
        certId.setCertHash(certHash);
        certId.setIssuerSerial(issuerSerial);
        return attr;
    }

    private byte[] getCertHash(IX509Certificate cert, String algorithmName) {
        try {
            IDigester digester = DigestTools.createDigester((String)algorithmName);
            IDigest digest = digester.digest(cert.getEncoded());
            return digest.getBytes();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private IssuerSerial getIssuerSerial(IX509Certificate cert) throws IOException {
        GeneralNames generalNames = (GeneralNames)GeneralNames.FACTORY.createNew();
        Name issuer = (Name)Name.FACTORY.create((ASN1Encodable)ASN1Tools.create((byte[])cert.getIssuerX500Principal().getEncoded()));
        GeneralName name = GeneralName.create((Name)issuer);
        generalNames.addName(name);
        IssuerSerial issuerSerial = (IssuerSerial)IssuerSerial.FACTORY.createNew();
        issuerSerial.setIssuer(generalNames);
        issuerSerial.setSerial(CertificateSerialNumber.create((BigInteger)cert.getSerialNumber()));
        return issuerSerial;
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }
}

